/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="An externally managed catalog")
public class ExternalCatalog
extends Catalog {
    @Valid
    private final ConnectionConfigInfo connectionConfigInfo;

    @ApiModelProperty(value="")
    @JsonProperty(value="connectionConfigInfo")
    public ConnectionConfigInfo getConnectionConfigInfo() {
        return this.connectionConfigInfo;
    }

    @JsonCreator
    public ExternalCatalog(@JsonProperty(value="connectionConfigInfo") ConnectionConfigInfo connectionConfigInfo, @JsonProperty(value="type", required=true) Catalog.TypeEnum type, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="properties", required=true) CatalogProperties properties, @JsonProperty(value="createTimestamp") Long createTimestamp, @JsonProperty(value="lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value="entityVersion") Integer entityVersion, @JsonProperty(value="storageConfigInfo", required=true) StorageConfigInfo storageConfigInfo) {
        super(type, name, properties, createTimestamp, lastUpdateTimestamp, entityVersion, storageConfigInfo);
        this.connectionConfigInfo = connectionConfigInfo;
    }

    public ExternalCatalog(Catalog.TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        super(type, name, properties, storageConfigInfo);
        this.connectionConfigInfo = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Catalog.TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        return new Builder(type, name, properties, storageConfigInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalCatalog externalCatalog = (ExternalCatalog)o;
        return super.equals(o) && Objects.equals(this.connectionConfigInfo, externalCatalog.connectionConfigInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connectionConfigInfo);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalCatalog {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    connectionConfigInfo: ").append(this.toIndentedString(this.connectionConfigInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private ConnectionConfigInfo connectionConfigInfo;
        private Catalog.TypeEnum type;
        private String name;
        private CatalogProperties properties;
        private Long createTimestamp;
        private Long lastUpdateTimestamp;
        private Integer entityVersion;
        private StorageConfigInfo storageConfigInfo;

        private Builder() {
        }

        private Builder(Catalog.TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
            this.type = Objects.requireNonNullElse(type, Catalog.TypeEnum.INTERNAL);
            this.name = name;
            this.properties = properties;
            this.storageConfigInfo = storageConfigInfo;
        }

        public Builder setConnectionConfigInfo(ConnectionConfigInfo connectionConfigInfo) {
            this.connectionConfigInfo = connectionConfigInfo;
            return this;
        }

        public Builder setType(Catalog.TypeEnum type) {
            this.type = type;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setProperties(CatalogProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setCreateTimestamp(Long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder setEntityVersion(Integer entityVersion) {
            this.entityVersion = entityVersion;
            return this;
        }

        public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
            this.storageConfigInfo = storageConfigInfo;
            return this;
        }

        public ExternalCatalog build() {
            ExternalCatalog inst = new ExternalCatalog(this.connectionConfigInfo, this.type, this.name, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion, this.storageConfigInfo);
            return inst;
        }
    }
}

