/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalWithCredentialsCredentials;

@ApiModel(description="A user with its client id and secret. This type is returned when a new principal is created or when its credentials are rotated")
public class PrincipalWithCredentials {
    @NotNull
    @Valid
    private final Principal principal;
    @NotNull
    @Valid
    private final PrincipalWithCredentialsCredentials credentials;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="principal", required=true)
    public Principal getPrincipal() {
        return this.principal;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="credentials", required=true)
    public PrincipalWithCredentialsCredentials getCredentials() {
        return this.credentials;
    }

    @JsonCreator
    public PrincipalWithCredentials(@JsonProperty(value="principal", required=true) Principal principal, @JsonProperty(value="credentials", required=true) PrincipalWithCredentialsCredentials credentials) {
        this.principal = principal;
        this.credentials = credentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Principal principal, PrincipalWithCredentialsCredentials credentials) {
        return new Builder(principal, credentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalWithCredentials principalWithCredentials = (PrincipalWithCredentials)o;
        return Objects.equals(this.principal, principalWithCredentials.principal) && Objects.equals(this.credentials, principalWithCredentials.credentials);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.credentials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrincipalWithCredentials {\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Principal principal;
        private PrincipalWithCredentialsCredentials credentials;

        private Builder() {
        }

        private Builder(Principal principal, PrincipalWithCredentialsCredentials credentials) {
            this.principal = principal;
            this.credentials = credentials;
        }

        public Builder setPrincipal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public Builder setCredentials(PrincipalWithCredentialsCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public PrincipalWithCredentials build() {
            PrincipalWithCredentials inst = new PrincipalWithCredentials(this.principal, this.credentials);
            return inst;
        }
    }
}

