/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcda;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.pipe.connector.protocol.opcda.OpcDaServerHandle;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaConnector;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcDaConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcDaConnector.class);
    private static final Map<String, Pair<AtomicInteger, OpcDaServerHandle>> CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP = new ConcurrentHashMap<String, Pair<AtomicInteger, OpcDaServerHandle>>();
    private String clsID;
    private OpcDaServerHandle handle;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false || (Boolean)args[2] != false || (Boolean)args[3] != false, String.format("One of '%s', '%s', '%s' and '%s' must be specified", "sink.opcda.clsid", "connector.opcda.clsid", "sink.opcda.progid", "connector.opcda.progid"), new Object[]{validator.getParameters().hasAttribute("sink.opcda.clsid"), validator.getParameters().hasAttribute("connector.opcda.clsid"), validator.getParameters().hasAttribute("sink.opcda.progid"), validator.getParameters().hasAttribute("connector.opcda.progid")});
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            throw new PipeParameterNotValidException("opc-da-sink must run on windows system.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        Map<String, Pair<AtomicInteger, OpcDaServerHandle>> map = CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP;
        synchronized (map) {
            this.clsID = parameters.getStringByKeys(new String[]{"connector.opcda.clsid", "sink.opcda.clsid"});
            if (Objects.isNull(this.clsID)) {
                this.clsID = OpcDaServerHandle.getClsIDFromProgID(parameters.getStringByKeys(new String[]{"connector.opcda.progid", "sink.opcda.progid"}));
            }
            this.handle = (OpcDaServerHandle)CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP.computeIfAbsent(this.clsID, key -> new Pair((Object)new AtomicInteger(0), (Object)new OpcDaServerHandle(this.clsID))).getRight();
            ((AtomicInteger)CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP.get(this.clsID).getLeft()).incrementAndGet();
        }
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        OpcUaConnector.transferByTablet(tabletInsertionEvent, LOGGER, tablet -> this.handle.transfer((Tablet)tablet));
    }

    public void transfer(Event event) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (Objects.isNull(this.clsID)) {
            return;
        }
        Map<String, Pair<AtomicInteger, OpcDaServerHandle>> map = CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP;
        synchronized (map) {
            Pair<AtomicInteger, OpcDaServerHandle> pair = CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP.get(this.clsID);
            if (pair == null) {
                return;
            }
            if (((AtomicInteger)pair.getLeft()).decrementAndGet() <= 0) {
                try {
                    ((OpcDaServerHandle)pair.getRight()).close();
                }
                finally {
                    CLS_ID_TO_REFERENCE_COUNT_AND_HANDLE_MAP.remove(this.clsID);
                }
            }
        }
    }
}

