/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.NodeType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.metrics.utils.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricConfig.class);
    private List<ReporterType> metricReporterList = Collections.emptyList();
    private MetricLevel metricLevel = MetricLevel.IMPORTANT;
    private Integer asyncCollectPeriodInSecond = 5;
    private Integer prometheusReporterPort = 9091;
    private String prometheusReporterUsername = "";
    private String prometheusReporterPassword = "";
    private final IoTDBReporterConfig iotdbReporterConfig = new IoTDBReporterConfig();
    private InternalReporterType internalReporterType = InternalReporterType.MEMORY;
    private String pid = "";
    private final SystemType systemType = SystemType.getSystemType();
    private NodeType nodeType = NodeType.CONFIGNODE;
    private String clusterName = "defaultCluster";
    private int nodeId = 0;
    private long upTimeInNs = 0L;
    private String internalDatabase = "root.__system";

    public MetricConfig() {
        try {
            this.pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get pid, because ", (Throwable)e);
        }
    }

    public List<ReporterType> getMetricReporterList() {
        return this.metricReporterList;
    }

    public void setMetricReporterList(String metricReporterList) {
        this.metricReporterList = new ArrayList<ReporterType>();
        for (String type : metricReporterList.split(",")) {
            if (type.trim().length() == 0) continue;
            this.metricReporterList.add(ReporterType.valueOf(type));
        }
    }

    public InternalReporterType getInternalReportType() {
        return this.internalReporterType;
    }

    public void setInternalReportType(InternalReporterType internalReporterType) {
        this.internalReporterType = internalReporterType;
    }

    public MetricLevel getMetricLevel() {
        return this.metricLevel;
    }

    public void setMetricLevel(MetricLevel metricLevel) {
        this.metricLevel = metricLevel;
    }

    public Integer getAsyncCollectPeriodInSecond() {
        return this.asyncCollectPeriodInSecond;
    }

    public void setAsyncCollectPeriodInSecond(Integer asyncCollectPeriodInSecond) {
        this.asyncCollectPeriodInSecond = asyncCollectPeriodInSecond;
    }

    public Integer getPrometheusReporterPort() {
        return this.prometheusReporterPort;
    }

    public void setPrometheusReporterPort(Integer prometheusReporterPort) {
        this.prometheusReporterPort = prometheusReporterPort;
    }

    public boolean prometheusNeedAuth() {
        return this.prometheusReporterUsername != null && !this.prometheusReporterUsername.isEmpty();
    }

    public String getPrometheusReporterUsername() {
        return this.prometheusReporterUsername;
    }

    public String getDecodedPrometheusReporterUsername() {
        return new String(Base64.getDecoder().decode(this.prometheusReporterUsername), StandardCharsets.UTF_8);
    }

    public void setPrometheusReporterUsername(String prometheusReporterUsername) {
        this.prometheusReporterUsername = prometheusReporterUsername;
    }

    public String getPrometheusReporterPassword() {
        return this.prometheusReporterPassword;
    }

    public String getDecodedPrometheusReporterPassword() {
        return new String(Base64.getDecoder().decode(this.prometheusReporterPassword), StandardCharsets.UTF_8);
    }

    public void setPrometheusReporterPassword(String prometheusReporterPassword) {
        this.prometheusReporterPassword = prometheusReporterPassword;
    }

    public IoTDBReporterConfig getIoTDBReporterConfig() {
        return this.iotdbReporterConfig;
    }

    public String getPid() {
        return this.pid;
    }

    public SystemType getSystemType() {
        return this.systemType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public long getUpTimeInNs() {
        return this.upTimeInNs;
    }

    public String getInternalDatabase() {
        return this.internalDatabase;
    }

    public void updateClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void updateRpcInstance(NodeType nodeType, String internalDatabase) {
        this.nodeType = nodeType;
        this.internalDatabase = internalDatabase;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
        this.upTimeInNs = System.nanoTime();
    }

    public void copy(MetricConfig newMetricConfig) {
        this.metricReporterList = newMetricConfig.getMetricReporterList();
        this.metricLevel = newMetricConfig.getMetricLevel();
        this.asyncCollectPeriodInSecond = newMetricConfig.getAsyncCollectPeriodInSecond();
        this.prometheusReporterPort = newMetricConfig.getPrometheusReporterPort();
        this.prometheusReporterUsername = newMetricConfig.getPrometheusReporterUsername();
        this.prometheusReporterPassword = newMetricConfig.getPrometheusReporterPassword();
        this.internalReporterType = newMetricConfig.getInternalReportType();
        this.iotdbReporterConfig.copy(newMetricConfig.getIoTDBReporterConfig());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricConfig)) {
            return false;
        }
        MetricConfig anotherMetricConfig = (MetricConfig)obj;
        return this.metricReporterList.equals(anotherMetricConfig.getMetricReporterList()) && this.metricLevel.equals((Object)anotherMetricConfig.getMetricLevel()) && this.asyncCollectPeriodInSecond.equals(anotherMetricConfig.getAsyncCollectPeriodInSecond()) && this.prometheusReporterPort.equals(anotherMetricConfig.getPrometheusReporterPort()) && this.iotdbReporterConfig.equals(anotherMetricConfig.getIoTDBReporterConfig()) && this.internalReporterType.equals((Object)anotherMetricConfig.getInternalReportType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricReporterList, this.metricLevel, this.asyncCollectPeriodInSecond, this.prometheusReporterPort, this.iotdbReporterConfig, this.internalReporterType});
    }

    public static class IoTDBReporterConfig {
        private String host = "127.0.0.1";
        private Integer port = 6667;
        private String username = "root";
        private String password = "root";
        private Integer maxConnectionNumber = 3;
        private String location = "metric";
        private Integer pushPeriodInSecond = 15;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getMaxConnectionNumber() {
            return this.maxConnectionNumber;
        }

        public void setMaxConnectionNumber(Integer maxConnectionNumber) {
            this.maxConnectionNumber = maxConnectionNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Integer getPushPeriodInSecond() {
            return this.pushPeriodInSecond;
        }

        public void setPushPeriodInSecond(Integer pushPeriodInSecond) {
            this.pushPeriodInSecond = pushPeriodInSecond;
        }

        public void copy(IoTDBReporterConfig iotdbReporterConfig) {
            this.host = iotdbReporterConfig.getHost();
            this.port = iotdbReporterConfig.getPort();
            this.username = iotdbReporterConfig.getUsername();
            this.password = iotdbReporterConfig.getPassword();
            this.maxConnectionNumber = iotdbReporterConfig.getMaxConnectionNumber();
            this.pushPeriodInSecond = iotdbReporterConfig.getPushPeriodInSecond();
            this.location = iotdbReporterConfig.getLocation();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IoTDBReporterConfig that = (IoTDBReporterConfig)o;
            return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.location, that.location) && Objects.equals(this.pushPeriodInSecond, that.pushPeriodInSecond);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.username, this.password, this.location, this.pushPeriodInSecond);
        }
    }
}

