/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.tester;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jvyaml.Constructor;
import org.jvyaml.DefaultYAMLFactory;

public class SPFYamlTestDescriptor {
    private String comment;
    private Map<String, Map<String, ?>> tests;
    private Map<String, Object> zonedata;

    public SPFYamlTestDescriptor(Map<String, ?> source, int i) {
        this.setComment((String)source.get("description"));
        if (this.getComment() == null) {
            this.setComment("Test #" + i);
        }
        this.setTests((Map)source.get("tests"));
        this.setZonedata((Map)source.get("zonedata"));
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<String, Map<String, ?>> getTests() {
        return this.tests;
    }

    public void setTests(Map<String, Map<String, ?>> tests) {
        this.tests = tests;
    }

    public Map<String, ?> getZonedata() {
        return this.zonedata;
    }

    public void setZonedata(Map<String, Map<?, ?>> zonedata) {
        this.zonedata = new HashMap<String, Object>();
        Set<String> keys = zonedata.keySet();
        for (String hostname : keys) {
            String lowercase = hostname.toLowerCase(Locale.US);
            this.zonedata.put(lowercase, zonedata.get(hostname));
        }
    }

    public static List<SPFYamlTestDescriptor> loadTests(String filename) throws IOException {
        ArrayList<SPFYamlTestDescriptor> tests = new ArrayList<SPFYamlTestDescriptor>();
        InputStream is = SPFYamlTestDescriptor.class.getResourceAsStream(filename);
        System.out.println(filename + ": " + is);
        if (is != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            DefaultYAMLFactory fact = new DefaultYAMLFactory();
            Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner((Reader)br)), fact.createResolver()));
            int i = 1;
            while (ctor.checkData()) {
                Object o = ctor.getData();
                if (o instanceof Map) {
                    Map m = (Map)o;
                    SPFYamlTestDescriptor ts = new SPFYamlTestDescriptor(m, i);
                    tests.add(ts);
                }
                ++i;
            }
            return tests;
        }
        throw new FileNotFoundException("Unable to load the file");
    }
}

