/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class Limit {
    private final Optional<Integer> limit;

    public static Limit from(int limit) {
        if (limit > 0) {
            return new Limit(Optional.of(limit));
        }
        return Limit.unlimited();
    }

    public static Limit from(Optional<Integer> limit) {
        return limit.map(Limit::from).orElse(Limit.unlimited());
    }

    public static Limit unlimited() {
        return new Limit(Optional.empty());
    }

    public static Limit limit(int limit) {
        Preconditions.checkArgument(limit > 0, "limit should be positive");
        return new Limit(Optional.of(limit));
    }

    private Limit(Optional<Integer> limit) {
        this.limit = limit;
    }

    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public <T> Stream<T> applyOnStream(Stream<T> stream) {
        return this.limit.map(stream::limit).orElse(stream);
    }

    public final boolean equals(Object o) {
        if (o instanceof Limit) {
            Limit other = (Limit)o;
            return Objects.equals(this.limit, other.limit);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.limit);
    }
}

