/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.Objects;
import org.apache.james.dlp.api.DLPConfigurationItem;

public class DLPRules
implements Iterable<DLPConfigurationItem> {
    private final ImmutableList<DLPConfigurationItem> items;

    public DLPRules(ImmutableList<DLPConfigurationItem> items) throws DuplicateRulesIdsException {
        Preconditions.checkNotNull(items);
        this.checkNotContainDuplicateIds(items);
        this.items = items;
    }

    private void checkNotContainDuplicateIds(ImmutableList<DLPConfigurationItem> items) throws DuplicateRulesIdsException {
        long uniqueIdCount = items.stream().map(DLPConfigurationItem::getId).distinct().count();
        if (uniqueIdCount != (long)items.size()) {
            throw new DuplicateRulesIdsException();
        }
    }

    public ImmutableList<DLPConfigurationItem> getItems() {
        return this.items;
    }

    @Override
    public Iterator<DLPConfigurationItem> iterator() {
        return this.items.iterator();
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPRules) {
            DLPRules dlpConfiguration = (DLPRules)o;
            return Objects.equals(this.items, dlpConfiguration.items);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.items);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("items", this.items).toString();
    }

    public static final class DuplicateRulesIdsException
    extends RuntimeException {
    }
}

