/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.MethodCallId;

public class InvocationRequest {
    private final Method.Request.Name method;
    private final ObjectNode parameters;
    private final MethodCallId methodCallId;

    public static InvocationRequest deserialize(JsonNode[] json) {
        Preconditions.checkState((json.length == 3 ? 1 : 0) != 0, (Object)"should have three elements");
        Preconditions.checkState((boolean)json[0].isTextual(), (Object)"first element should be a String");
        Preconditions.checkState((boolean)json[1].isObject(), (Object)"second element should be a Json");
        Preconditions.checkState((boolean)json[2].isTextual(), (Object)"third element should be a String");
        return new InvocationRequest(Method.Request.name(json[0].textValue()), (ObjectNode)json[1], MethodCallId.of(json[2].textValue()));
    }

    protected InvocationRequest(Method.Request.Name method, ObjectNode parameters, MethodCallId methodCallId) {
        this.method = method;
        this.parameters = parameters;
        this.methodCallId = methodCallId;
    }

    public Method.Request.Name getMethodName() {
        return this.method;
    }

    public ObjectNode getParameters() {
        return this.parameters;
    }

    public MethodCallId getMethodCallId() {
        return this.methodCallId;
    }
}

