/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es.v7;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.DeleteByQueryPerformer;
import org.apache.james.backends.es.v7.DocumentId;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.backends.es.v7.UpdatedRepresentation;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ElasticSearchIndexer {
    private static final int DEBUG_MAX_LENGTH_CONTENT = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchIndexer.class);
    private final ReactorElasticSearchClient client;
    private final AliasName aliasName;
    private final DeleteByQueryPerformer deleteByQueryPerformer;

    public ElasticSearchIndexer(ReactorElasticSearchClient client, WriteAliasName aliasName) {
        this.client = client;
        this.deleteByQueryPerformer = new DeleteByQueryPerformer(client, aliasName);
        this.aliasName = aliasName;
    }

    public Mono<IndexResponse> index(DocumentId id, String content, RoutingKey routingKey) {
        this.checkArgument(content);
        this.logContent(id, content);
        return this.client.index(new IndexRequest(this.aliasName.getValue()).id(id.asString()).source(content, XContentType.JSON).routing(routingKey.asString()), RequestOptions.DEFAULT);
    }

    private void logContent(DocumentId id, String content) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Indexing {}: {}", (Object)id.asString(), (Object)StringUtils.left((String)content, (int)1000));
        }
    }

    public Mono<BulkResponse> update(List<UpdatedRepresentation> updatedDocumentParts, RoutingKey routingKey) {
        Preconditions.checkNotNull(updatedDocumentParts);
        Preconditions.checkNotNull((Object)routingKey);
        BulkRequest request = new BulkRequest();
        updatedDocumentParts.forEach(updatedDocumentPart -> request.add(new UpdateRequest(this.aliasName.getValue(), updatedDocumentPart.getId().asString()).doc(updatedDocumentPart.getUpdatedDocumentPart(), XContentType.JSON).routing(routingKey.asString())));
        return this.client.bulk(request, RequestOptions.DEFAULT).onErrorResume(ValidationException.class, exception -> {
            LOGGER.warn("Error while updating index", (Throwable)exception);
            return Mono.empty();
        });
    }

    public Mono<BulkResponse> delete(List<DocumentId> ids, RoutingKey routingKey) {
        BulkRequest request = new BulkRequest();
        ids.forEach(id -> request.add(new DeleteRequest(this.aliasName.getValue()).id(id.asString()).routing(routingKey.asString())));
        return this.client.bulk(request, RequestOptions.DEFAULT).onErrorResume(ValidationException.class, exception -> {
            LOGGER.warn("Error while deleting index", (Throwable)exception);
            return Mono.empty();
        });
    }

    public Mono<Void> deleteAllMatchingQuery(QueryBuilder queryBuilder, RoutingKey routingKey) {
        return this.deleteByQueryPerformer.perform(queryBuilder, routingKey);
    }

    private void checkArgument(String content) {
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content should be provided");
    }

    public Mono<GetResponse> get(DocumentId id, RoutingKey routingKey) {
        return Mono.fromRunnable(() -> {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)routingKey);
        }).then(this.client.get(new GetRequest(this.aliasName.getValue()).id(id.asString()).routing(routingKey.asString()), RequestOptions.DEFAULT));
    }
}

