/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonArrayBuilderImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonObjectBuilderImpl;
import org.apache.activemq.artemis.commons.shaded.json.JsonArrayBuilder;
import org.apache.activemq.artemis.commons.shaded.json.JsonBuilderFactory;
import org.apache.activemq.artemis.commons.shaded.json.JsonObjectBuilder;

class JsonBuilderFactoryImpl
implements JsonBuilderFactory {
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final String[] SUPPORTED_CONFIG_KEYS = new String[0];
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    JsonBuilderFactoryImpl(Map<String, ?> config) {
        if (config != null && config.size() > 0) {
            List<String> supportedConfigKeys = Arrays.asList(SUPPORTED_CONFIG_KEYS);
            for (String configKey : config.keySet()) {
                if (supportedConfigKeys.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                this.logger.warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl();
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl();
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

