/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyLDAPUsersDAO;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.UsersRepositoryImpl;

public class ReadOnlyUsersLDAPRepository
extends UsersRepositoryImpl<ReadOnlyLDAPUsersDAO>
implements Configurable {
    private LdapRepositoryConfiguration ldapConfiguration;

    @Inject
    public ReadOnlyUsersLDAPRepository(DomainList domainList) {
        super(domainList, (UsersDAO)new ReadOnlyLDAPUsersDAO());
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.configure(LdapRepositoryConfiguration.from(configuration));
        super.configure(configuration);
    }

    public void configure(LdapRepositoryConfiguration configuration) {
        ((ReadOnlyLDAPUsersDAO)this.usersDAO).configure(configuration);
        this.ldapConfiguration = configuration;
    }

    @PostConstruct
    public void init() throws Exception {
        ((ReadOnlyLDAPUsersDAO)this.usersDAO).init();
    }

    public boolean supportVirtualHosting() {
        return this.ldapConfiguration.supportsVirtualHosting();
    }

    public boolean isAdministrator(Username username) throws UsersRepositoryException {
        this.assertValid(username);
        if (this.ldapConfiguration.getAdministratorId().isPresent()) {
            return this.ldapConfiguration.getAdministratorId().get().equals((Object)username);
        }
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }
}

