/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;

public class MultimailboxesSearchQuery {
    private final SearchQuery searchQuery;
    private final ImmutableSet<MailboxId> inMailboxes;
    private final ImmutableSet<MailboxId> notInMailboxes;

    public static Builder from(SearchQuery searchQuery) {
        return new Builder(searchQuery);
    }

    @VisibleForTesting
    MultimailboxesSearchQuery(SearchQuery searchQuery, ImmutableSet<MailboxId> inMailboxes, ImmutableSet<MailboxId> notInMailboxes) {
        this.searchQuery = searchQuery;
        this.inMailboxes = inMailboxes;
        this.notInMailboxes = notInMailboxes;
    }

    public ImmutableSet<MailboxId> getInMailboxes() {
        return this.inMailboxes;
    }

    public ImmutableSet<MailboxId> getNotInMailboxes() {
        return this.notInMailboxes;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public static class Builder {
        private final SearchQuery searchQuery;
        private ImmutableSet.Builder<MailboxId> mailboxIds;
        private ImmutableSet.Builder<MailboxId> notInMailboxIds;

        private Builder(SearchQuery searchQuery) {
            Preconditions.checkNotNull(searchQuery);
            this.searchQuery = searchQuery;
            this.mailboxIds = ImmutableSet.builder();
            this.notInMailboxIds = ImmutableSet.builder();
        }

        public Builder inMailboxes(Collection<MailboxId> mailboxIds) {
            this.mailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder inMailboxes(MailboxId ... mailboxIds) {
            return this.inMailboxes(Arrays.asList(mailboxIds));
        }

        public Builder notInMailboxes(Collection<MailboxId> mailboxIds) {
            this.notInMailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder notInMailboxes(MailboxId ... mailboxIds) {
            return this.notInMailboxes(Arrays.asList(mailboxIds));
        }

        public MultimailboxesSearchQuery build() {
            return new MultimailboxesSearchQuery(this.searchQuery, (ImmutableSet<MailboxId>)this.mailboxIds.build(), (ImmutableSet<MailboxId>)this.notInMailboxIds.build());
        }
    }
}

