/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class PathHierarchyTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    private final int bufferSize;
    private final String delimiter;
    private final String replacement;
    private final boolean reverse;
    private final int skip;
    public static final JsonpDeserializer<PathHierarchyTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PathHierarchyTokenizer::setupPathHierarchyTokenizerDeserializer);

    private PathHierarchyTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = ApiTypeHelper.requireNonNull(builder.bufferSize, this, "bufferSize");
        this.delimiter = ApiTypeHelper.requireNonNull(builder.delimiter, this, "delimiter");
        this.replacement = ApiTypeHelper.requireNonNull(builder.replacement, this, "replacement");
        this.reverse = ApiTypeHelper.requireNonNull(builder.reverse, this, "reverse");
        this.skip = ApiTypeHelper.requireNonNull(builder.skip, this, "skip");
    }

    public static PathHierarchyTokenizer of(Function<Builder, ObjectBuilder<PathHierarchyTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.PathHierarchy;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final boolean reverse() {
        return this.reverse;
    }

    public final int skip() {
        return this.skip;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "path_hierarchy");
        super.serializeInternal(generator, mapper);
        generator.writeKey("buffer_size");
        generator.write(this.bufferSize);
        generator.writeKey("delimiter");
        generator.write(this.delimiter);
        generator.writeKey("replacement");
        generator.write(this.replacement);
        generator.writeKey("reverse");
        generator.write(this.reverse);
        generator.writeKey("skip");
        generator.write(this.skip);
    }

    protected static void setupPathHierarchyTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size");
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.add(Builder::reverse, JsonpDeserializer.booleanDeserializer(), "reverse");
        op.add(Builder::skip, JsonpDeserializer.integerDeserializer(), "skip");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PathHierarchyTokenizer> {
        private Integer bufferSize;
        private String delimiter;
        private String replacement;
        private Boolean reverse;
        private Integer skip;

        public final Builder bufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        public final Builder delimiter(String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder replacement(String value) {
            this.replacement = value;
            return this;
        }

        public final Builder reverse(boolean value) {
            this.reverse = value;
            return this;
        }

        public final Builder skip(int value) {
            this.skip = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PathHierarchyTokenizer build() {
            this._checkSingleUse();
            return new PathHierarchyTokenizer(this);
        }
    }
}

