/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import com.github.fge.lambdas.Throwing;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.util.EnumSet;
import java.util.Optional;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.trustmanager.TrustStoreTrustOptions;
import nl.altindag.ssl.util.PemUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.protocols.api.ClientAuth;
import org.apache.james.protocols.lib.SslConfig;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyJavaEncryptionFactory
implements Encryption.Factory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurableAsyncServer.class);
    private final FileSystem fileSystem;
    private final SslConfig sslConfig;

    public LegacyJavaEncryptionFactory(FileSystem fileSystem, SslConfig sslConfig) {
        this.fileSystem = fileSystem;
        this.sslConfig = sslConfig;
    }

    public Encryption create() throws Exception {
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withSslContextAlgorithm("TLS");
        if (this.sslConfig.getKeystore() != null) {
            char[] passwordAsCharArray = Optional.ofNullable(this.sslConfig.getSecret()).orElse("").toCharArray();
            LOGGER.debug("Building SSL config for keystore({}) at {}", (Object)this.sslConfig.getKeystoreType(), (Object)this.fileSystem.getFile(this.sslConfig.getKeystore()).toPath().toAbsolutePath());
            sslFactoryBuilder.withIdentityMaterial(this.fileSystem.getFile(this.sslConfig.getKeystore()).toPath(), passwordAsCharArray, passwordAsCharArray, this.sslConfig.getKeystoreType());
        } else {
            X509ExtendedKeyManager keyManager = PemUtils.loadIdentityMaterial((InputStream)this.fileSystem.getResource(this.sslConfig.getCertificates()), (InputStream)this.fileSystem.getResource(this.sslConfig.getPrivateKey()), (char[])Optional.ofNullable(this.sslConfig.getSecret()).map(String::toCharArray).orElse(null));
            sslFactoryBuilder.withIdentityMaterial((X509KeyManager)keyManager);
        }
        if (this.sslConfig.getClientAuth() != null && this.sslConfig.getTruststore() != null) {
            Optional<TrustStoreTrustOptions<? extends CertPathTrustManagerParameters>> maybeTrustOptions = this.clientAuthTrustOptions(this.sslConfig);
            maybeTrustOptions.ifPresentOrElse(Throwing.consumer(trustOptions -> sslFactoryBuilder.withTrustMaterial(this.fileSystem.getFile(this.sslConfig.getTruststore()).toPath(), this.sslConfig.getTruststoreSecret(), this.sslConfig.getKeystoreType(), trustOptions)).sneakyThrow(), (Runnable)Throwing.runnable(() -> sslFactoryBuilder.withTrustMaterial(this.fileSystem.getFile(this.sslConfig.getTruststore()).toPath(), this.sslConfig.getTruststoreSecret(), this.sslConfig.getKeystoreType())));
        }
        SSLContext context = sslFactoryBuilder.build().getSslContext();
        if (this.sslConfig.useStartTLS()) {
            return Encryption.createStartTls((SSLContext)context, (String[])this.sslConfig.getEnabledCipherSuites(), (String[])this.sslConfig.getEnabledProtocols(), (ClientAuth)this.sslConfig.getClientAuth());
        }
        return Encryption.createTls((SSLContext)context, (String[])this.sslConfig.getEnabledCipherSuites(), (String[])this.sslConfig.getEnabledProtocols(), (ClientAuth)this.sslConfig.getClientAuth());
    }

    private Optional<TrustStoreTrustOptions<? extends CertPathTrustManagerParameters>> clientAuthTrustOptions(SslConfig sslConfig) throws NoSuchAlgorithmException {
        if (!sslConfig.ocspCRLChecksEnabled()) {
            return Optional.empty();
        }
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
        PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
        revocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.NO_FALLBACK));
        return Optional.of(trustStore -> {
            PKIXBuilderParameters pkixBuilderParameters = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            pkixBuilderParameters.addCertPathChecker(revocationChecker);
            return new CertPathTrustManagerParameters(pkixBuilderParameters);
        });
    }
}

