/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;

public class RecipientRewriteTableUserEntityValidator
implements UserEntityValidator {
    private static final Map<UserEntityValidator.EntityType, Mapping.Type> TYPE_CORRESPONDENCE = ImmutableMap.of((Object)UserEntityValidator.EntityType.ALIAS, (Object)Mapping.Type.Alias, (Object)UserEntityValidator.EntityType.GROUP, (Object)Mapping.Type.Group);
    private final RecipientRewriteTable rrt;

    @Inject
    public RecipientRewriteTableUserEntityValidator(RecipientRewriteTable rrt) {
        this.rrt = rrt;
    }

    @Override
    public Optional<UserEntityValidator.ValidationFailure> canCreate(Username username, Set<UserEntityValidator.EntityType> ignoredTypes) throws RecipientRewriteTableException {
        Mappings mappings = this.rrt.getStoredMappings(MappingSource.fromUser((Username)username));
        return this.filterIgnored(mappings, ignoredTypes).findFirst().map(mapping -> new UserEntityValidator.ValidationFailure("'" + username.asString() + "' already have associated mappings: " + mapping.asString()));
    }

    private Stream<Mapping> filterIgnored(Mappings mappings, Set<UserEntityValidator.EntityType> ignoredTypes) {
        ImmutableSet types = (ImmutableSet)ignoredTypes.stream().flatMap(type -> Optional.ofNullable(TYPE_CORRESPONDENCE.get(type)).stream()).collect(ImmutableSet.toImmutableSet());
        return mappings.asStream().filter(mapping -> !types.contains((Object)mapping.getType()));
    }
}

