/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.hybrid.internal.HpkeKemPrivateKey;
import com.google.crypto.tink.subtle.X25519;
import com.google.crypto.tink.util.Bytes;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;

@Immutable
final class X25519HpkeKemPrivateKey
implements HpkeKemPrivateKey {
    private final Bytes privateKey;
    private final Bytes publicKey;

    static X25519HpkeKemPrivateKey fromBytes(byte[] privateKey) throws GeneralSecurityException {
        return new X25519HpkeKemPrivateKey(privateKey, X25519.publicFromPrivate(privateKey));
    }

    private X25519HpkeKemPrivateKey(byte[] privateKey, byte[] publicKey) {
        this.privateKey = Bytes.copyFrom(privateKey);
        this.publicKey = Bytes.copyFrom(publicKey);
    }

    @Override
    public Bytes getSerializedPrivate() {
        return this.privateKey;
    }

    @Override
    public Bytes getSerializedPublic() {
        return this.publicKey;
    }
}

