/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtPublicKeySign;
import com.google.crypto.tink.jwt.JwtPublicKeySignInternal;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;

class JwtPublicKeySignWrapper
implements PrimitiveWrapper<JwtPublicKeySignInternal, JwtPublicKeySign> {
    private static void validate(PrimitiveSet<JwtPublicKeySignInternal> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
        for (List<PrimitiveSet.Entry<JwtPublicKeySignInternal>> entries : primitiveSet.getAll()) {
            for (PrimitiveSet.Entry<JwtPublicKeySignInternal> entry : entries) {
                if (entry.getOutputPrefixType() == OutputPrefixType.RAW || entry.getOutputPrefixType() == OutputPrefixType.TINK) continue;
                throw new GeneralSecurityException("unsupported OutputPrefixType");
            }
        }
    }

    JwtPublicKeySignWrapper() {
    }

    @Override
    public JwtPublicKeySign wrap(PrimitiveSet<JwtPublicKeySignInternal> primitives) throws GeneralSecurityException {
        JwtPublicKeySignWrapper.validate(primitives);
        return new WrappedJwtPublicKeySign(primitives);
    }

    @Override
    public Class<JwtPublicKeySign> getPrimitiveClass() {
        return JwtPublicKeySign.class;
    }

    @Override
    public Class<JwtPublicKeySignInternal> getInputPrimitiveClass() {
        return JwtPublicKeySignInternal.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new JwtPublicKeySignWrapper());
    }

    @Immutable
    private static class WrappedJwtPublicKeySign
    implements JwtPublicKeySign {
        private final PrimitiveSet<JwtPublicKeySignInternal> primitives;

        public WrappedJwtPublicKeySign(PrimitiveSet<JwtPublicKeySignInternal> primitives) {
            this.primitives = primitives;
        }

        @Override
        public String signAndEncode(RawJwt token) throws GeneralSecurityException {
            PrimitiveSet.Entry<JwtPublicKeySignInternal> entry = this.primitives.getPrimary();
            Optional<String> kid = JwtFormat.getKid(entry.getKeyId(), entry.getOutputPrefixType());
            return this.primitives.getPrimary().getPrimitive().signAndEncodeWithKid(token, kid);
        }
    }
}

