/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class TlsConfiguration {
    private final String keystoreFilePath;
    private final String keystorePassword;
    private final String truststoreFilePath;
    private final String truststorePassword;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    TlsConfiguration(String keystoreFilePath, String keystorePassword, String truststoreFilePath, String truststorePassword) {
        this.keystoreFilePath = keystoreFilePath;
        this.keystorePassword = keystorePassword;
        this.truststoreFilePath = truststoreFilePath;
        this.truststorePassword = truststorePassword;
    }

    public String getKeystoreFilePath() {
        return this.keystoreFilePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getTruststoreFilePath() {
        return this.truststoreFilePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public final boolean equals(Object o) {
        if (o instanceof TlsConfiguration) {
            TlsConfiguration that = (TlsConfiguration)o;
            return Objects.equals(this.keystoreFilePath, that.keystoreFilePath) && Objects.equals(this.keystorePassword, that.keystorePassword) && Objects.equals(this.truststoreFilePath, that.truststoreFilePath) && Objects.equals(this.truststorePassword, that.truststorePassword);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.keystoreFilePath, this.keystorePassword, this.truststoreFilePath, this.truststorePassword);
    }

    public static class Builder {
        private String keystoreFilePath;
        private String keystorePassword;
        private String truststoreFilePath;
        private String truststorePassword;

        public Builder raw(String keystoreFilePath, String keystorePassword, String truststoreFilePath, String truststorePassword) {
            Preconditions.checkNotNull((Object)keystoreFilePath);
            Preconditions.checkNotNull((Object)keystorePassword);
            this.keystoreFilePath = keystoreFilePath;
            this.keystorePassword = keystorePassword;
            this.truststoreFilePath = truststoreFilePath;
            this.truststorePassword = truststorePassword;
            return this;
        }

        public Builder selfSigned(String keystoreFilePath, String keystorePassword) {
            Preconditions.checkNotNull((Object)keystoreFilePath);
            Preconditions.checkNotNull((Object)keystorePassword);
            this.keystoreFilePath = keystoreFilePath;
            this.keystorePassword = keystorePassword;
            return this;
        }

        public TlsConfiguration build() {
            Preconditions.checkState((boolean)this.hasKeystoreInformation(), (Object)"If enabled, you need to provide keystore information");
            Preconditions.checkState((boolean)this.optionalHasTrustStoreInformation(), (Object)"You need to provide both information about trustStore");
            return new TlsConfiguration(this.keystoreFilePath, this.keystorePassword, this.truststoreFilePath, this.truststorePassword);
        }

        private boolean optionalHasTrustStoreInformation() {
            return this.truststoreFilePath == null == (this.truststorePassword == null);
        }

        private boolean hasKeystoreInformation() {
            return this.keystorePassword != null && this.keystoreFilePath != null;
        }
    }
}

