/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.activemq.artemis.utils.uri.FluentPropertyBeanIntrospectorWithIgnores;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class BeanSupport {
    private static final BeanUtilsBean beanUtils = new BeanUtilsBean();
    private static final Map<Converter, Class> customConverters = new HashMap<Converter, Class>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConverter(Converter converter, Class type) {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.getConvertUtils().register(converter, type);
            customConverters.put(converter, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void customise(BeanUtilsBean bean) {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            customConverters.forEach((key, value) -> bean.getConvertUtils().register(key, value));
        }
        bean.getPropertyUtils().addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospectorWithIgnores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> P copyData(P source, P target) throws Exception {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.copyProperties(source, target);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> P setData(URI uri, P obj, Map<String, String> query) throws Exception {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.setProperty(obj, "host", (Object)uri.getHost());
            beanUtils.setProperty(obj, "port", (Object)uri.getPort());
            beanUtils.setProperty(obj, "userInfo", (Object)uri.getUserInfo());
            beanUtils.populate(obj, query);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> P setData(P obj, Map<String, Object> data) throws Exception {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.populate(obj, data);
        }
        return obj;
    }

    public static <T> void stripPasswords(Map<String, T> properties) {
        properties.entrySet().removeIf(entry -> ((String)entry.getKey()).toLowerCase().contains("password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> P setProperties(P bean, Properties properties) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = beanUtils.getPropertyUtils().getPropertyDescriptors(bean)) {
                String value;
                if (descriptor.getReadMethod() == null || !BeanSupport.isWriteable(descriptor, null) || (value = properties.getProperty(descriptor.getName())) == null) continue;
                beanUtils.setProperty(bean, descriptor.getName(), (Object)value);
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> Properties getProperties(P bean, Properties properties) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = beanUtils.getPropertyUtils().getPropertyDescriptors(bean)) {
                String value;
                if (descriptor.getReadMethod() == null || !BeanSupport.isWriteable(descriptor, null) || (value = beanUtils.getProperty(bean, descriptor.getName())) == null) continue;
                properties.put(descriptor.getName(), value);
            }
        }
        return properties;
    }

    public static void setData(URI uri, HashMap<String, Object> properties, Set<String> allowableProperties, Map<String, String> query, Map<String, Object> extraProps) {
        if (allowableProperties.contains("scheme")) {
            properties.put("scheme", uri.getScheme());
        }
        if (allowableProperties.contains("host")) {
            properties.put("host", uri.getHost());
        }
        if (allowableProperties.contains("port")) {
            properties.put("port", "" + uri.getPort());
        }
        if (allowableProperties.contains("userInfo")) {
            properties.put("userInfo", uri.getUserInfo());
        }
        for (Map.Entry<String, String> entry : query.entrySet()) {
            if (allowableProperties.contains(entry.getKey())) {
                properties.put(entry.getKey(), entry.getValue());
                continue;
            }
            extraProps.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getData(List<String> ignored, Object ... beans) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            for (Object bean : beans) {
                PropertyDescriptor[] descriptors;
                if (bean == null) continue;
                for (PropertyDescriptor descriptor : descriptors = beanUtils.getPropertyUtils().getPropertyDescriptors(bean)) {
                    String value;
                    if (descriptor.getReadMethod() == null || !BeanSupport.isWriteable(descriptor, ignored) || (value = beanUtils.getProperty(bean, descriptor.getName())) == null) continue;
                    if (!empty) {
                        sb.append("&");
                    }
                    empty = false;
                    sb.append(descriptor.getName()).append("=").append(BeanSupport.encodeURI(value));
                }
            }
        }
        return sb.toString();
    }

    private static boolean isWriteable(PropertyDescriptor descriptor, List<String> ignored) {
        if (ignored != null && ignored.contains(descriptor.getName())) {
            return false;
        }
        Class<?> type = descriptor.getPropertyType();
        return type == Double.class || type == Double.TYPE || type == Long.class || type == Long.TYPE || type == Integer.class || type == Integer.TYPE || type == Float.class || type == Float.TYPE || type == Boolean.class || type == Boolean.TYPE || type == String.class;
    }

    public static String decodeURI(String value) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, "UTF-8");
    }

    public static String encodeURI(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    static {
        beanUtils.getPropertyUtils().addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospectorWithIgnores());
        BeanSupport.registerConverter(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value == null) {
                    return null;
                }
                if (String.class.equals(type) || Object.class.equals(type)) {
                    return type.cast(value.toString());
                }
                if (type.isEnum()) {
                    return Enum.valueOf(type, value.toString());
                }
                throw new ConversionException("Can't convert value '" + value + "' to type " + type);
            }
        }, String.class);
    }
}

