/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.Externalizer;
import org.apache.openjpa.persistence.Factory;

@Entity(name="MailboxMessage")
@Table(name="JAMES_MAIL")
public class JPAEncryptedMailboxMessage
extends AbstractJPAMailboxMessage
implements PersistenceCapable {
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    @Externalizer(value="EncryptDecryptHelper.getEncrypted")
    @Factory(value="EncryptDecryptHelper.getDecrypted")
    @Lob
    private byte[] body;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    @Externalizer(value="EncryptDecryptHelper.getEncrypted")
    @Factory(value="EncryptDecryptHelper.getDecrypted")
    @Lob
    private byte[] header;
    private static int pcInheritedFieldCount = AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage;

    public JPAEncryptedMailboxMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, Content content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        try {
            int headerEnd = bodyStartOctet;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            InputStream stream = content.getInputStream();
            this.header = IOUtils.toByteArray((InputStream)new BoundedInputStream(stream, (long)this.getBodyStartOctet()));
            this.body = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public JPAEncryptedMailboxMessage(JPAMailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.body = IOUtils.toByteArray((InputStream)message.getBodyContent());
            this.header = IOUtils.toByteArray((InputStream)message.getHeaderContent());
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        return new ByteArrayInputStream(JPAEncryptedMailboxMessage.pcGetbody(this));
    }

    public InputStream getHeaderContent() throws IOException {
        return new ByteArrayInputStream(JPAEncryptedMailboxMessage.pcGetheader(this));
    }

    public MailboxMessage copy(Mailbox mailbox) throws MailboxException {
        return new JPAEncryptedMailboxMessage(JPAMailbox.from(mailbox), this.getUid(), this.getModSeq(), this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    public JPAEncryptedMailboxMessage() {
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage = JPAEncryptedMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = JPAEncryptedMailboxMessage.class$("[B"));
        classArray[0] = clazz2;
        classArray[1] = class$L$B != null ? class$L$B : (class$L$B = JPAEncryptedMailboxMessage.class$("[B"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 21};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage = JPAEncryptedMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMailboxMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailboxMessage", (PersistenceCapable)new JPAEncryptedMailboxMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage = new JPAEncryptedMailboxMessage();
        if (bl) {
            jPAEncryptedMailboxMessage.pcClearFields();
        }
        jPAEncryptedMailboxMessage.pcStateManager = stateManager;
        jPAEncryptedMailboxMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAEncryptedMailboxMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage = new JPAEncryptedMailboxMessage();
        if (bl) {
            jPAEncryptedMailboxMessage.pcClearFields();
        }
        jPAEncryptedMailboxMessage.pcStateManager = stateManager;
        return jPAEncryptedMailboxMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAEncryptedMailboxMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAEncryptedMailboxMessage.body;
                return;
            }
            case 1: {
                this.header = jPAEncryptedMailboxMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage = (JPAEncryptedMailboxMessage)object;
        if (jPAEncryptedMailboxMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAEncryptedMailboxMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAEncryptedMailboxMessage = JPAEncryptedMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMailboxMessage"));
        return clazz;
    }

    private static final byte[] pcGetbody(JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage) {
        if (jPAEncryptedMailboxMessage.pcStateManager == null) {
            return jPAEncryptedMailboxMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAEncryptedMailboxMessage.pcStateManager.accessingField(n);
        return jPAEncryptedMailboxMessage.body;
    }

    private static final void pcSetbody(JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage, byte[] byArray) {
        if (jPAEncryptedMailboxMessage.pcStateManager == null) {
            jPAEncryptedMailboxMessage.body = byArray;
            return;
        }
        jPAEncryptedMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAEncryptedMailboxMessage, pcInheritedFieldCount + 0, (Object)jPAEncryptedMailboxMessage.body, (Object)byArray, 0);
    }

    private static final byte[] pcGetheader(JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage) {
        if (jPAEncryptedMailboxMessage.pcStateManager == null) {
            return jPAEncryptedMailboxMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAEncryptedMailboxMessage.pcStateManager.accessingField(n);
        return jPAEncryptedMailboxMessage.header;
    }

    private static final void pcSetheader(JPAEncryptedMailboxMessage jPAEncryptedMailboxMessage, byte[] byArray) {
        if (jPAEncryptedMailboxMessage.pcStateManager == null) {
            jPAEncryptedMailboxMessage.header = byArray;
            return;
        }
        jPAEncryptedMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAEncryptedMailboxMessage, pcInheritedFieldCount + 1, (Object)jPAEncryptedMailboxMessage.header, (Object)byArray, 0);
    }
}

