/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.DomainList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.AddressParser;
import org.apache.james.mime4j.stream.ParserCursor;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.james.mime4j.util.ContentUtil;

public class LenientAddressParser
implements AddressParser {
    private static final int AT = 64;
    private static final int OPENING_BRACKET = 60;
    private static final int CLOSING_BRACKET = 62;
    private static final int COMMA = 44;
    private static final int COLON = 58;
    private static final int SEMICOLON = 59;
    private static final BitSet AT_AND_CLOSING_BRACKET = RawFieldParser.INIT_BITSET((int[])new int[]{64, 62});
    private static final BitSet CLOSING_BRACKET_ONLY = RawFieldParser.INIT_BITSET((int[])new int[]{62});
    private static final BitSet COMMA_ONLY = RawFieldParser.INIT_BITSET((int[])new int[]{44});
    private static final BitSet COLON_ONLY = RawFieldParser.INIT_BITSET((int[])new int[]{58});
    private static final BitSet SEMICOLON_ONLY = RawFieldParser.INIT_BITSET((int[])new int[]{59});
    public static final LenientAddressParser DEFAULT = new LenientAddressParser(DecodeMonitor.SILENT);
    private final DecodeMonitor monitor;
    private final RawFieldParser parser;

    protected LenientAddressParser(DecodeMonitor monitor) {
        this.monitor = monitor;
        this.parser = new RawFieldParser();
    }

    String parseDomain(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        StringBuilder dst = new StringBuilder();
        while (!cursor.atEnd()) {
            char current = (char)(buf.byteAt(cursor.getPos()) & 0xFF);
            if (delimiters != null && delimiters.get(current)) break;
            if (CharsetUtil.isWhitespace((char)current)) {
                this.parser.skipWhiteSpace(buf, cursor);
                continue;
            }
            if (current == '(') {
                this.parser.skipComment(buf, cursor);
                continue;
            }
            this.parser.copyContent(buf, cursor, delimiters, dst);
        }
        return dst.toString();
    }

    DomainList parseRoute(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        ArrayList<String> domains;
        block5: {
            int pos;
            char current;
            BitSet bitset = RawFieldParser.INIT_BITSET((int[])new int[]{44, 58});
            if (delimiters != null) {
                bitset.or(delimiters);
            }
            domains = null;
            while (true) {
                this.parser.skipAllWhiteSpace(buf, cursor);
                if (cursor.atEnd() || (current = (char)(buf.byteAt(pos = cursor.getPos()) & 0xFF)) != '@') break block5;
                cursor.updatePos(pos + 1);
                String s = this.parseDomain(buf, cursor, bitset);
                if (s != null && s.length() > 0) {
                    if (domains == null) {
                        domains = new ArrayList<String>();
                    }
                    domains.add(s);
                }
                if (cursor.atEnd()) break block5;
                pos = cursor.getPos();
                current = (char)(buf.byteAt(pos) & 0xFF);
                if (current != ',') break;
                cursor.updatePos(pos + 1);
            }
            if (current == ':') {
                cursor.updatePos(pos + 1);
            }
        }
        return domains != null ? new DomainList(domains) : null;
    }

    private Mailbox createMailbox(String name, DomainList route, String localPart, String domain) {
        return new Mailbox(name != null ? DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)this.monitor) : null, route, localPart, domain);
    }

    Mailbox parseMailboxAddress(String openingText, ByteSequence buf, ParserCursor cursor) {
        if (cursor.atEnd()) {
            return this.createMailbox(null, null, openingText, null);
        }
        int pos = cursor.getPos();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current != '<') {
            return this.createMailbox(null, null, openingText, null);
        }
        cursor.updatePos(pos + 1);
        DomainList domainList = this.parseRoute(buf, cursor, CLOSING_BRACKET_ONLY);
        String localPart = this.parser.parseValue(buf, cursor, AT_AND_CLOSING_BRACKET);
        if (cursor.atEnd()) {
            return this.createMailbox(openingText, domainList, localPart, null);
        }
        pos = cursor.getPos();
        current = (char)(buf.byteAt(pos) & 0xFF);
        if (current != '@') {
            return this.createMailbox(openingText, domainList, localPart, null);
        }
        cursor.updatePos(pos + 1);
        String domain = this.parseDomain(buf, cursor, CLOSING_BRACKET_ONLY);
        if (cursor.atEnd()) {
            return this.createMailbox(openingText, domainList, localPart, domain);
        }
        pos = cursor.getPos();
        current = (char)(buf.byteAt(pos) & 0xFF);
        if (current == '>') {
            cursor.updatePos(pos + 1);
        } else {
            return this.createMailbox(openingText, domainList, localPart, domain);
        }
        while (!cursor.atEnd()) {
            pos = cursor.getPos();
            current = (char)(buf.byteAt(pos) & 0xFF);
            if (CharsetUtil.isWhitespace((char)current)) {
                this.parser.skipWhiteSpace(buf, cursor);
                continue;
            }
            if (current != '(') break;
            this.parser.skipComment(buf, cursor);
        }
        return this.createMailbox(openingText, domainList, localPart, domain);
    }

    private Mailbox createMailbox(String localPart) {
        if (localPart != null && localPart.length() > 0) {
            return new Mailbox(null, null, DecoderUtil.decodeEncodedWords((String)localPart, (DecodeMonitor)this.monitor), null);
        }
        return null;
    }

    public Mailbox parseMailbox(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        BitSet bitset = RawFieldParser.INIT_BITSET((int[])new int[]{64, 60});
        if (delimiters != null) {
            bitset.or(delimiters);
        }
        String openingText = this.parser.parseValue(buf, cursor, bitset);
        if (cursor.atEnd()) {
            return this.createMailbox(openingText);
        }
        int pos = cursor.getPos();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current == '<') {
            return this.parseMailboxAddress(openingText, buf, cursor);
        }
        if (current == '@') {
            cursor.updatePos(pos + 1);
            String domain = this.parseDomain(buf, cursor, delimiters);
            return new Mailbox(null, null, openingText, domain);
        }
        return this.createMailbox(openingText);
    }

    @Override
    public Mailbox parseMailbox(CharSequence text) {
        ByteSequence raw = ContentUtil.encode((CharSequence)text);
        ParserCursor cursor = new ParserCursor(0, text.length());
        return this.parseMailbox(raw, cursor, null);
    }

    List<Mailbox> parseMailboxes(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        BitSet bitset = RawFieldParser.INIT_BITSET((int[])new int[]{44});
        if (delimiters != null) {
            bitset.or(delimiters);
        }
        ArrayList<Mailbox> mboxes = new ArrayList<Mailbox>();
        while (!cursor.atEnd()) {
            int pos = cursor.getPos();
            char current = (char)(buf.byteAt(pos) & 0xFF);
            if (delimiters != null && delimiters.get(current)) break;
            if (current == ',') {
                cursor.updatePos(pos + 1);
                continue;
            }
            Mailbox mbox = this.parseMailbox(buf, cursor, bitset);
            if (mbox == null) continue;
            mboxes.add(mbox);
        }
        return mboxes;
    }

    public Group parseGroup(ByteSequence buf, ParserCursor cursor) {
        String name = this.parser.parseToken(buf, cursor, COLON_ONLY);
        if (cursor.atEnd()) {
            return new Group(name, Collections.emptyList());
        }
        int pos = cursor.getPos();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current == ':') {
            cursor.updatePos(pos + 1);
        }
        List<Mailbox> mboxes = this.parseMailboxes(buf, cursor, SEMICOLON_ONLY);
        return new Group(name, mboxes);
    }

    @Override
    public Group parseGroup(CharSequence text) {
        ByteSequence raw = ContentUtil.encode((CharSequence)text);
        ParserCursor cursor = new ParserCursor(0, text.length());
        return this.parseGroup(raw, cursor);
    }

    public Address parseAddress(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        BitSet bitset = RawFieldParser.INIT_BITSET((int[])new int[]{58, 64, 60});
        if (delimiters != null) {
            bitset.or(delimiters);
        }
        String openingText = this.parser.parseValue(buf, cursor, bitset);
        if (cursor.atEnd()) {
            return this.createMailbox(openingText);
        }
        int pos = cursor.getPos();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current == '<') {
            return this.parseMailboxAddress(openingText, buf, cursor);
        }
        if (current == '@') {
            cursor.updatePos(pos + 1);
            String domain = this.parseDomain(buf, cursor, delimiters);
            return new Mailbox(null, null, openingText, domain);
        }
        if (current == ':') {
            cursor.updatePos(pos + 1);
            List<Mailbox> mboxes = this.parseMailboxes(buf, cursor, SEMICOLON_ONLY);
            if (!cursor.atEnd() && (current = (char)(buf.byteAt(pos = cursor.getPos()) & 0xFF)) == ';') {
                cursor.updatePos(pos + 1);
            }
            return new Group(openingText, mboxes);
        }
        return this.createMailbox(openingText);
    }

    @Override
    public Address parseAddress(CharSequence text) {
        ByteSequence raw = ContentUtil.encode((CharSequence)text);
        ParserCursor cursor = new ParserCursor(0, text.length());
        return this.parseAddress(raw, cursor, null);
    }

    public AddressList parseAddressList(ByteSequence buf, ParserCursor cursor) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        while (!cursor.atEnd()) {
            int pos = cursor.getPos();
            char current = (char)(buf.byteAt(pos) & 0xFF);
            if (current == ',') {
                cursor.updatePos(pos + 1);
                continue;
            }
            Address address = this.parseAddress(buf, cursor, COMMA_ONLY);
            if (address == null) continue;
            addresses.add(address);
        }
        return new AddressList(addresses, false);
    }

    @Override
    public AddressList parseAddressList(CharSequence text) {
        ByteSequence raw = ContentUtil.encode((CharSequence)text);
        ParserCursor cursor = new ParserCursor(0, text.length());
        return this.parseAddressList(raw, cursor);
    }
}

