/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.resource;

import java.io.File;
import java.io.IOException;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.filesystem.ResourceFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DefaultJamesResourceLoader
extends DefaultResourceLoader
implements JamesResourceLoader {
    private final JamesDirectoriesProvider jamesDirectoriesProvider;
    private final ResourceFactory resourceFactory;

    public DefaultJamesResourceLoader(JamesDirectoriesProvider jamesDirectoriesProvider) {
        this.jamesDirectoriesProvider = jamesDirectoriesProvider;
        this.resourceFactory = new ResourceFactory(jamesDirectoriesProvider);
    }

    @Override
    public void validate(File file) throws IOException {
        this.resourceFactory.validate(file);
    }

    public Resource getResource(String fileURL) {
        ClassPathResource r;
        if (fileURL.startsWith("classpath:")) {
            String resourceName = fileURL.substring("classpath:".length());
            r = new ClassPathResource(resourceName);
        } else if (fileURL.startsWith("file://")) {
            File file = fileURL.startsWith("file://conf/") ? new File(this.jamesDirectoriesProvider.getConfDirectory() + "/" + fileURL.substring("file://conf/".length())) : (fileURL.startsWith("file://var/") ? new File(this.jamesDirectoriesProvider.getVarDirectory() + "/" + fileURL.substring("file://var/".length())) : (fileURL.startsWith("file:///") ? new File(this.jamesDirectoriesProvider.getAbsoluteDirectory() + fileURL.substring("file:///".length())) : new File(this.jamesDirectoriesProvider.getRootDirectory() + "/" + fileURL.substring("file://".length()))));
            r = new FileSystemResource(file);
        } else {
            return null;
        }
        return r;
    }

    public String getAbsoluteDirectory() {
        return this.jamesDirectoriesProvider.getAbsoluteDirectory();
    }

    public String getConfDirectory() {
        return this.jamesDirectoriesProvider.getConfDirectory();
    }

    public String getVarDirectory() {
        return this.jamesDirectoriesProvider.getVarDirectory();
    }

    public String getRootDirectory() {
        return this.jamesDirectoriesProvider.getRootDirectory();
    }
}

