/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.smtpserver.netty.SMTPServer;
import org.apache.james.smtpserver.netty.SMTPServerFactory;
import org.apache.james.util.Port;
import org.apache.james.utils.GuiceProbe;

public class SmtpGuiceProbe
implements GuiceProbe {
    private final SMTPServerFactory smtpServerFactory;

    @Inject
    private SmtpGuiceProbe(SMTPServerFactory smtpServerFactory) {
        this.smtpServerFactory = smtpServerFactory;
    }

    public Port getSmtpPort() {
        return this.getPort(server -> true);
    }

    public Port getSmtpStartTlsPort() {
        return this.getPort(AbstractConfigurableAsyncServer::getStartTLSSupported);
    }

    public Port getSmtpSslPort() {
        return this.getPort(server -> server.getSocketType().equals("secure"));
    }

    public Port getSmtpAuthRequiredPort() {
        return this.getPort(server -> ((SMTPServer)server).getAuthRequired().equals((Object)SMTPServer.AuthenticationAnnounceMode.FOR_UNAUTHORIZED_ADDRESSES));
    }

    private Port getPort(Predicate<? super AbstractConfigurableAsyncServer> filter) {
        return this.smtpServerFactory.getServers().stream().filter(filter).findFirst().flatMap(server -> server.getListenAddresses().stream().findFirst()).map(InetSocketAddress::getPort).map(Port::new).orElseThrow(() -> new IllegalStateException("SMTP server not defined"));
    }

    public static enum SmtpServerConnectedType {
        SMTP_GLOBAL_SERVER(SmtpGuiceProbe::getSmtpPort),
        SMTP_START_TLS_SERVER(SmtpGuiceProbe::getSmtpStartTlsPort);

        private final Function<SmtpGuiceProbe, Port> portExtractor;

        private SmtpServerConnectedType(Function<SmtpGuiceProbe, Port> portExtractor) {
            this.portExtractor = portExtractor;
        }

        public Function<SmtpGuiceProbe, Port> getPortExtractor() {
            return this.portExtractor;
        }
    }
}

