/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.implicits$;
import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Date;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.EmailHeader;
import org.apache.james.jmap.mail.EmailHeaderValue;
import org.apache.james.jmap.mail.EmailHeaders;
import org.apache.james.jmap.mail.HeaderMessageId;
import org.apache.james.jmap.mail.MessageIdsHeaderValue;
import org.apache.james.jmap.mail.MessageIdsHeaderValue$;
import org.apache.james.jmap.mail.RawHeaderValue;
import org.apache.james.jmap.mail.SpecificHeaderRequest$;
import org.apache.james.jmap.mail.Subject;
import org.apache.james.jmap.mail.Subject$;
import org.apache.james.jmap.mail.UncheckedAddressesHeaderValue;
import org.apache.james.jmap.mail.UncheckedEmailAddress$;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.MimeUtil;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class EmailHeaders$
implements Serializable {
    public static final EmailHeaders$ MODULE$ = new EmailHeaders$();
    private static final String SPECIFIC_HEADER_PREFIX = "header:";

    public String SPECIFIC_HEADER_PREFIX() {
        return SPECIFIC_HEADER_PREFIX;
    }

    public EmailHeaders from(ZoneId zoneId, Message mime4JMessage) {
        List<EmailHeader> x$1 = this.asEmailHeaders(mime4JMessage.getHeader());
        MessageIdsHeaderValue x$2 = this.extractMessageId(mime4JMessage, "Message-Id");
        MessageIdsHeaderValue x$3 = this.extractMessageId(mime4JMessage, "In-Reply-To");
        MessageIdsHeaderValue x$4 = this.extractMessageId(mime4JMessage, "References");
        Option<UncheckedAddressesHeaderValue> x$5 = this.extractAddresses(mime4JMessage, "To");
        Option<UncheckedAddressesHeaderValue> x$6 = this.extractAddresses(mime4JMessage, "Cc");
        Option<UncheckedAddressesHeaderValue> x$7 = this.extractAddresses(mime4JMessage, "Bcc");
        Option<UncheckedAddressesHeaderValue> x$8 = this.extractAddresses(mime4JMessage, "From");
        Option<UncheckedAddressesHeaderValue> x$9 = this.extractAddresses(mime4JMessage, "Reply-To");
        Option<UncheckedAddressesHeaderValue> x$10 = this.extractAddresses(mime4JMessage, "Sender");
        Option<Subject> x$11 = this.extractSubject(mime4JMessage);
        Option x$12 = this.extractDate(mime4JMessage, "Date").map((Function1 & Serializable)date -> UTCDate$.MODULE$.from((Date)date, zoneId));
        return new EmailHeaders(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$9, x$11, (Option<UTCDate>)x$12);
    }

    public Map<String, Option<EmailHeaderValue>> extractSpecificHeaders(Option<Properties> properties, ZoneId zoneId, Header header) {
        return ((IterableOnceOps)((IterableOps)((Properties)properties.getOrElse((Function0 & Serializable)() -> Properties$.MODULE$.empty())).value().flatMap((Function1 & Serializable)property -> EmailHeaders$.$anonfun$extractSpecificHeaders$2((String)((Refined)property).value()))).map((Function1 & Serializable)x$9 -> x$9.retrieveHeader(zoneId, header))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private List<EmailHeader> asEmailHeaders(Header header2) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(header2.iterator()).asScala().map((Function1 & Serializable)header -> new EmailHeader(header.getName(), new RawHeaderValue(new String(header.getRaw().toByteArray(), StandardCharsets.US_ASCII).substring(header.getName().length() + 1)))).toList();
    }

    private Option<Subject> extractSubject(Message mime4JMessage) {
        return this.extractLastField(mime4JMessage, "Subject").map((Function1 & Serializable)x$10 -> x$10.getBody()).map((Function1 & Serializable)x$1 -> MimeUtil.unscrambleHeaderValue((String)x$1)).map((Function1)Subject$.MODULE$);
    }

    private MessageIdsHeaderValue extractMessageId(Message mime4JMessage, String fieldName) {
        return new MessageIdsHeaderValue((Option<List<HeaderMessageId>>)Option$.MODULE$.apply((Object)mime4JMessage.getHeader().getFields(fieldName)).map((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11).asScala().toList()).flatMap((Function1 & Serializable)fields -> ((Option)implicits$.MODULE$.toTraverseOps((Object)fields.map((Function1 & Serializable)field -> MessageIdsHeaderValue$.MODULE$.from((Field)field).value()), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForOption())).map((Function1 & Serializable)x$12 -> (List)x$12.flatten(Predef$.MODULE$.$conforms()))).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.nonEmpty())));
    }

    private Option<UncheckedAddressesHeaderValue> extractAddresses(Message mime4JMessage, String fieldName) {
        return this.extractLastField(mime4JMessage, fieldName).flatMap((Function1 & Serializable)x0$1 -> {
            Field field = x0$1;
            if (field instanceof AddressListField) {
                AddressListField addressListField = (AddressListField)field;
                return new Some((Object)new UncheckedAddressesHeaderValue(UncheckedEmailAddress$.MODULE$.from(addressListField.getAddressList())));
            }
            if (field instanceof MailboxListField) {
                MailboxListField mailboxListField = (MailboxListField)field;
                return new Some((Object)new UncheckedAddressesHeaderValue(UncheckedEmailAddress$.MODULE$.from(mailboxListField.getMailboxList())));
            }
            if (field instanceof MailboxField) {
                MailboxField mailboxField = (MailboxField)field;
                AddressListField asMailboxListField = (AddressListField)AddressListFieldLenientImpl.PARSER.parse((Field)RawFieldParser.DEFAULT.parseField(mailboxField.getRaw()), DecodeMonitor.SILENT);
                return new Some((Object)new UncheckedAddressesHeaderValue(UncheckedEmailAddress$.MODULE$.from(asMailboxListField.getAddressList())));
            }
            return None$.MODULE$;
        }).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)EmailHeaders$.$anonfun$extractAddresses$2(x$14)));
    }

    private Option<Date> extractDate(Message mime4JMessage, String fieldName) {
        return this.extractLastField(mime4JMessage, fieldName).flatMap((Function1 & Serializable)x0$1 -> {
            Field field = x0$1;
            if (field instanceof DateTimeField) {
                DateTimeField dateTimeField = (DateTimeField)field;
                return Option$.MODULE$.apply((Object)dateTimeField.getDate());
            }
            return None$.MODULE$;
        });
    }

    private Option<Field> extractLastField(Message mime4JMessage, String fieldName) {
        return Option$.MODULE$.apply((Object)mime4JMessage.getHeader().getFields(fieldName)).map((Function1 & Serializable)x$15 -> CollectionConverters$.MODULE$.ListHasAsScala(x$15).asScala()).flatMap((Function1 & Serializable)fields -> ((IterableOps)fields.reverse()).headOption());
    }

    public EmailHeaders apply(List<EmailHeader> headers, MessageIdsHeaderValue messageId, MessageIdsHeaderValue inReplyTo, MessageIdsHeaderValue references, Option<UncheckedAddressesHeaderValue> to, Option<UncheckedAddressesHeaderValue> cc, Option<UncheckedAddressesHeaderValue> bcc, Option<UncheckedAddressesHeaderValue> from, Option<UncheckedAddressesHeaderValue> sender, Option<UncheckedAddressesHeaderValue> replyTo, Option<Subject> subject, Option<UTCDate> sentAt) {
        return new EmailHeaders(headers, messageId, inReplyTo, references, to, cc, bcc, from, sender, replyTo, subject, sentAt);
    }

    public Option<Tuple12<List<EmailHeader>, MessageIdsHeaderValue, MessageIdsHeaderValue, MessageIdsHeaderValue, Option<UncheckedAddressesHeaderValue>, Option<UncheckedAddressesHeaderValue>, Option<UncheckedAddressesHeaderValue>, Option<UncheckedAddressesHeaderValue>, Option<UncheckedAddressesHeaderValue>, Option<UncheckedAddressesHeaderValue>, Option<Subject>, Option<UTCDate>>> unapply(EmailHeaders x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12(x$0.headers(), (Object)x$0.messageId(), (Object)x$0.inReplyTo(), (Object)x$0.references(), x$0.to(), x$0.cc(), x$0.bcc(), x$0.from(), x$0.sender(), x$0.replyTo(), x$0.subject(), x$0.sentAt()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EmailHeaders$.class);
    }

    public static final /* synthetic */ Option $anonfun$extractSpecificHeaders$2(String property) {
        return SpecificHeaderRequest$.MODULE$.from(property).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$extractAddresses$2(UncheckedAddressesHeaderValue x$14) {
        return x$14.value().nonEmpty();
    }

    private EmailHeaders$() {
    }
}

