/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FingerprintAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final String version;
    private final int maxOutputSize;
    private final boolean preserveOriginal;
    private final String separator;
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<FingerprintAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintAnalyzer::setupFingerprintAnalyzerDeserializer);

    private FingerprintAnalyzer(Builder builder) {
        this.version = builder.version;
        this.maxOutputSize = ApiTypeHelper.requireNonNull(builder.maxOutputSize, this, "maxOutputSize");
        this.preserveOriginal = ApiTypeHelper.requireNonNull(builder.preserveOriginal, this, "preserveOriginal");
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
        this.stopwordsPath = builder.stopwordsPath;
    }

    public static FingerprintAnalyzer of(Function<Builder, ObjectBuilder<FingerprintAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Fingerprint;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    public final int maxOutputSize() {
        return this.maxOutputSize;
    }

    public final boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    public final String separator() {
        return this.separator;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        generator.writeKey("max_output_size");
        generator.write(this.maxOutputSize);
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
        generator.writeKey("separator");
        generator.write(this.separator);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    protected static void setupFingerprintAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FingerprintAnalyzer> {
        @Nullable
        private String version;
        private Integer maxOutputSize;
        private Boolean preserveOriginal;
        private String separator;
        @Nullable
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder maxOutputSize(int value) {
            this.maxOutputSize = value;
            return this;
        }

        public final Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        public FingerprintAnalyzer build() {
            this._checkSingleUse();
            return new FingerprintAnalyzer(this);
        }
    }
}

