/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.pit;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.pit.CreatePitResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class CreatePitRequest
extends RequestBase {
    private List<String> targetIndexes;
    private Time keepAlive;
    @Nullable
    private String preference;
    @Nullable
    private String routing;
    @Nullable
    private List<ExpandWildcard> expandWildcards;
    @Nullable
    private Boolean allowPartialPitCreation;
    public static final Endpoint<CreatePitRequest, CreatePitResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreatePitRequest, CreatePitResponse>(request -> "POST", request -> {
        boolean _targetIndexes = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.targetIndexes.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search/point_in_time");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keep_alive", request.keepAlive._toJsonString());
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.allowPartialPitCreation != null) {
            params.put("allow_partial_pit_creation", String.valueOf(request.allowPartialPitCreation));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CreatePitResponse._DESERIALIZER);

    private CreatePitRequest(Builder builder) {
        this.targetIndexes = ApiTypeHelper.unmodifiableRequired(builder.targetIndexes, (Object)this, "targetIndexes");
        this.keepAlive = ApiTypeHelper.requireNonNull(builder.keepAlive, this, "keepAlive");
        this.preference = builder.preference;
        this.routing = builder.routing;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.allowPartialPitCreation = builder.allowPartialPitCreation;
    }

    public static CreatePitRequest of(Function<Builder, ObjectBuilder<CreatePitRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> targetIndexes() {
        return this.targetIndexes;
    }

    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean allowPartialPitCreation() {
        return this.allowPartialPitCreation;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CreatePitRequest> {
        private List<String> targetIndexes;
        private Time keepAlive;
        @Nullable
        private String preference;
        @Nullable
        private String routing;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean allowPartialPitCreation;

        public final Builder targetIndexes(List<String> list) {
            this.targetIndexes = Builder._listAddAll(this.targetIndexes, list);
            return this;
        }

        public final Builder targetIndexes(String value, String ... values) {
            this.targetIndexes = Builder._listAdd(this.targetIndexes, value, values);
            return this;
        }

        public final Builder keepAlive(Time keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder preference(@Nullable String preference) {
            this.preference = preference;
            return this;
        }

        public final Builder routing(@Nullable String routing) {
            this.routing = routing;
            return this;
        }

        public final Builder expandWildcards(@Nullable List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder allowPartialPitCreation(@Nullable Boolean allowPartialPitCreation) {
            this.allowPartialPitCreation = allowPartialPitCreation;
            return this;
        }

        @Override
        public CreatePitRequest build() {
            this._checkSingleUse();
            return new CreatePitRequest(this);
        }
    }
}

