/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregateLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck {
    @NotNull
    private final List<LDAPConnectionPoolHealthCheck> healthChecks;

    public AggregateLDAPConnectionPoolHealthCheck(LDAPConnectionPoolHealthCheck ... healthChecks) {
        this(StaticUtils.toList(healthChecks));
    }

    public AggregateLDAPConnectionPoolHealthCheck(@NotNull Collection<? extends LDAPConnectionPoolHealthCheck> healthChecks) {
        this.healthChecks = healthChecks == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<LDAPConnectionPoolHealthCheck>(healthChecks));
    }

    @Override
    public void ensureNewConnectionValid(@NotNull LDAPConnection connection) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureNewConnectionValid(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureConnectionValidAfterAuthentication(connection, bindResult);
        }
    }

    @Override
    public void ensureConnectionValidForCheckout(@NotNull LDAPConnection connection) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureConnectionValidForCheckout(connection);
        }
    }

    @Override
    public void ensureConnectionValidForRelease(@NotNull LDAPConnection connection) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureConnectionValidForRelease(connection);
        }
    }

    @Override
    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureConnectionValidForContinuedUse(connection);
        }
    }

    @Override
    public void performPoolMaintenance(@NotNull AbstractConnectionPool pool) {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.performPoolMaintenance(pool);
        }
    }

    @Override
    public void ensureConnectionValidAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) throws LDAPException {
        for (LDAPConnectionPoolHealthCheck hc : this.healthChecks) {
            hc.ensureConnectionValidAfterException(connection, exception);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AggregateLDAPConnectionPoolHealthCheck(healthChecks={");
        Iterator<LDAPConnectionPoolHealthCheck> iterator = this.healthChecks.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

