/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ThirdPartyTask
extends Task {
    @NotNull
    static final String THIRD_PARTY_TASK_CLASS = "com.unboundid.directory.sdk.extensions.ThirdPartyTask";
    @NotNull
    private static final String ATTR_THIRD_PARTY_TASK_CLASS = "ds-third-party-task-java-class";
    @NotNull
    private static final String ATTR_THIRD_PARTY_TASK_ARGUMENT = "ds-third-party-task-argument";
    @NotNull
    private static final String OC_THIRD_PARTY_TASK = "ds-third-party-task";
    @NotNull
    static final TaskProperty PROPERTY_TASK_CLASS = new TaskProperty("ds-third-party-task-java-class", TaskMessages.INFO_DISPLAY_NAME_THIRD_PARTY_TASK_CLASS.get(), TaskMessages.INFO_DESCRIPTION_THIRD_PARTY_TASK_CLASS.get(), String.class, true, false, false);
    @NotNull
    static final TaskProperty PROPERTY_TASK_ARG = new TaskProperty("ds-third-party-task-argument", TaskMessages.INFO_DISPLAY_NAME_THIRD_PARTY_TASK_ARG.get(), TaskMessages.INFO_DESCRIPTION_THIRD_PARTY_TASK_ARG.get(), String.class, false, true, false);
    private static final long serialVersionUID = 8448474409066265724L;
    @NotNull
    private final List<String> taskArguments;
    @NotNull
    private final String taskClassName;

    public ThirdPartyTask() {
        this.taskArguments = null;
        this.taskClassName = null;
    }

    public ThirdPartyTask(@Nullable String taskID, @NotNull String taskClassName, @Nullable List<String> taskArguments) {
        this(taskID, taskClassName, taskArguments, null, null, null, null, null);
    }

    public ThirdPartyTask(@Nullable String taskID, @NotNull String taskClassName, @Nullable List<String> taskArguments, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, taskClassName, taskArguments, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ThirdPartyTask(@Nullable String taskID, @NotNull String taskClassName, @Nullable List<String> taskArguments, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, THIRD_PARTY_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(taskClassName);
        this.taskClassName = taskClassName;
        this.taskArguments = taskArguments == null ? Collections.emptyList() : Collections.unmodifiableList(taskArguments);
    }

    public ThirdPartyTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.taskClassName = entry.getAttributeValue(ATTR_THIRD_PARTY_TASK_CLASS);
        if (this.taskClassName == null) {
            throw new TaskException(TaskMessages.ERR_THIRD_PARTY_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        String[] args = entry.getAttributeValues(ATTR_THIRD_PARTY_TASK_ARGUMENT);
        this.taskArguments = args == null || args.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    public ThirdPartyTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(THIRD_PARTY_TASK_CLASS, properties);
        String className = null;
        String[] args = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_THIRD_PARTY_TASK_CLASS)) {
                className = ThirdPartyTask.parseString(p, values, null);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_THIRD_PARTY_TASK_ARGUMENT)) continue;
            args = ThirdPartyTask.parseStrings(p, values, null);
        }
        if (className == null) {
            throw new TaskException(TaskMessages.ERR_THIRD_PARTY_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        this.taskClassName = className;
        this.taskArguments = args == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_THIRD_PARTY_TASK.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_THIRD_PARTY_TASK.get();
    }

    @NotNull
    public String getThirdPartyTaskClassName() {
        return this.taskClassName;
    }

    @NotNull
    public List<String> getThirdPartyTaskArguments() {
        return this.taskArguments;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_THIRD_PARTY_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(2);
        attrList.add(new Attribute(ATTR_THIRD_PARTY_TASK_CLASS, this.taskClassName));
        if (!this.taskArguments.isEmpty()) {
            attrList.add(new Attribute(ATTR_THIRD_PARTY_TASK_ARGUMENT, this.taskArguments));
        }
        return attrList;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_TASK_CLASS, PROPERTY_TASK_ARG));
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(2));
        props.put(PROPERTY_TASK_CLASS, Collections.singletonList(this.taskClassName));
        props.put(PROPERTY_TASK_ARG, Collections.unmodifiableList(this.taskArguments));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

