/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class WeakHashSet<T>
implements Set<T> {
    @NotNull
    private final WeakHashMap<T, WeakReference<T>> m;

    public WeakHashSet() {
        this.m = new WeakHashMap(16);
    }

    public WeakHashSet(int initialCapacity) {
        this.m = new WeakHashMap(initialCapacity);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean contains(@NotNull Object e) {
        return this.m.containsKey(e);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.m.keySet().containsAll(c);
    }

    @Nullable
    public T get(@NotNull T e) {
        WeakReference<T> r = this.m.get(e);
        if (r == null) {
            return null;
        }
        return r.get();
    }

    @Override
    public boolean add(@NotNull T e) {
        if (this.m.containsKey(e)) {
            return false;
        }
        this.m.put(e, new WeakReference<T>(e));
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean changed = false;
        for (T e : c) {
            if (this.m.containsKey(e)) continue;
            this.m.put(e, new WeakReference<T>(e));
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T addAndGet(@NotNull T e) {
        Object existingElement;
        WeakReference<T> r = this.m.get(e);
        if (r != null && (existingElement = r.get()) != null) {
            return existingElement;
        }
        this.m.put(e, new WeakReference<T>(e));
        return e;
    }

    @Override
    public boolean remove(@NotNull Object e) {
        return this.m.remove(e) != null;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            WeakReference<T> e = this.m.remove(o);
            if (e == null) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean changed = false;
        Iterator<Map.Entry<T, WeakReference<T>>> iterator = this.m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, WeakReference<T>> e = iterator.next();
            if (c.contains(e.getKey())) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.m.keySet().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.m.keySet().toArray();
    }

    @Override
    @NotNull
    public <E> E[] toArray(@NotNull E[] a) {
        return this.m.keySet().toArray(a);
    }

    @Override
    public int hashCode() {
        return this.m.keySet().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o != null && o instanceof Set && this.m.keySet().equals(o);
    }

    @NotNull
    public String toString() {
        return this.m.keySet().toString();
    }
}

