/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class DataCentersFinder {
    DataCentersFinder() {
    }

    Set<String> getDataCenters(InternalDriverContext driverContext) {
        return this.getDataCenters(driverContext.getMetadataManager().getMetadata().getNodes().values(), driverContext.getConfig().getDefaultProfile());
    }

    @VisibleForTesting
    Set<String> getDataCenters(Collection<Node> nodes, DriverExecutionProfile executionProfile) {
        int remoteConnectionsLength = executionProfile.getInt(DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE);
        HashSet<String> dataCenters = new HashSet<String>();
        for (Node n : nodes) {
            NodeDistance distance = n.getDistance();
            if (!distance.equals((Object)NodeDistance.LOCAL) && (!distance.equals((Object)NodeDistance.REMOTE) || remoteConnectionsLength <= 0)) continue;
            dataCenters.add(n.getDatacenter());
        }
        return dataCenters;
    }
}

