/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.util.SpecialAddressesUtils;
import org.apache.mailet.Mail;

public class RecipientsUtils {
    private final RedirectNotify mailet;

    public static RecipientsUtils from(RedirectNotify mailet) {
        return new RecipientsUtils(mailet);
    }

    private RecipientsUtils(RedirectNotify mailet) {
        this.mailet = mailet;
    }

    public List<MailAddress> getRecipients(Mail originalMail) throws MessagingException {
        List<MailAddress> recipients = this.mailet.getRecipients();
        if (!recipients.isEmpty()) {
            if (this.containsOnlyUnalteredOrRecipients(recipients)) {
                return ImmutableList.of();
            }
            return SpecialAddressesUtils.from(this.mailet).replaceSpecialAddresses(originalMail, recipients);
        }
        return ImmutableList.of();
    }

    private boolean containsOnlyUnalteredOrRecipients(List<MailAddress> recipients) {
        return recipients.size() == 1 && (recipients.contains(SpecialAddress.UNALTERED) || recipients.contains(SpecialAddress.RECIPIENTS));
    }
}

