/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCmdHandler
extends AbstractPOP3CommandHandler
implements CapaCapability {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"USER");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"USER");
    private final MetricFactory metricFactory;

    @Inject
    public UserCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-user", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "USER").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.user(session, request)));
    }

    private Response user(POP3Session session, Request request) {
        LOGGER.trace("USER command received");
        String parameters = request.getArgument();
        if (session.getHandlerState() == 0 && parameters != null) {
            try {
                session.setUsername(Username.of((String)parameters));
                session.setHandlerState(1);
                return POP3Response.OK;
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("USER command input error", (Throwable)e);
                return POP3Response.ERR;
            }
        }
        return POP3Response.ERR;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        return CAPS;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

