/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasTask;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.service.UserQuotaService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.QuotaDTOValidator;
import org.apache.james.webadmin.validation.Quotas;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class UserQuotaRoutes
implements Routes {
    public static final String USER_QUOTAS_OPERATIONS_INJECTION_KEY = "userQuotasOperations";
    private static final TaskRegistrationKey RECOMPUTE_CURRENT_QUOTAS = TaskRegistrationKey.of((String)"RecomputeCurrentQuotas");
    private static final String USER = "user";
    private static final String MIN_OCCUPATION_RATIO = "minOccupationRatio";
    private static final String MAX_OCCUPATION_RATIO = "maxOccupationRatio";
    private static final String DOMAIN = "domain";
    public static final String USERS_QUOTA_ENDPOINT = "/quota/users";
    private static final String QUOTA_ENDPOINT = "/quota/users/:user";
    private static final String COUNT_ENDPOINT = "/quota/users/:user/count";
    private static final String SIZE_ENDPOINT = "/quota/users/:user/size";
    private final UsersRepository usersRepository;
    private final UserQuotaService userQuotaService;
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<QuotaDTO> jsonExtractor;
    private final QuotaDTOValidator quotaDTOValidator;
    private final TaskManager taskManager;
    private final Set<TaskFromRequestRegistry.TaskRegistration> usersQuotasTaskRegistration;
    private Service service;

    @Inject
    public UserQuotaRoutes(UsersRepository usersRepository, UserQuotaService userQuotaService, JsonTransformer jsonTransformer, Set<JsonTransformerModule> modules, TaskManager taskManager, @Named(value="userQuotasOperations") Set<TaskFromRequestRegistry.TaskRegistration> usersQuotasTaskRegistration) {
        this.usersRepository = usersRepository;
        this.userQuotaService = userQuotaService;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(QuotaDTO.class, modules.stream().map(JsonTransformerModule::asJacksonModule).collect(Collectors.toList()));
        this.quotaDTOValidator = new QuotaDTOValidator();
        this.taskManager = taskManager;
        this.usersQuotasTaskRegistration = usersQuotasTaskRegistration;
    }

    public String getBasePath() {
        return USERS_QUOTA_ENDPOINT;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetQuotaCount();
        this.defineDeleteQuotaCount();
        this.defineUpdateQuotaCount();
        this.defineGetQuotaSize();
        this.defineDeleteQuotaSize();
        this.defineUpdateQuotaSize();
        this.defineGetQuota();
        this.defineUpdateQuota();
        this.defineGetUsersQuota();
        this.definePostUsersQuota();
        this.definePostUsersQuota().ifPresent(route -> service.post(USERS_QUOTA_ENDPOINT, route, (ResponseTransformer)this.jsonTransformer));
    }

    public Optional<Route> definePostUsersQuota() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.usersQuotasTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    public void defineUpdateQuota() {
        this.service.put(QUOTA_ENDPOINT, (request, response) -> {
            try {
                Username username = this.checkUserExist(request);
                QuotaDTO quotaDTO = (QuotaDTO)this.jsonExtractor.parse(request.body());
                ValidatedQuotaDTO validatedQuotaDTO = this.quotaDTOValidator.validatedQuotaDTO(quotaDTO);
                this.userQuotaService.defineQuota(username, validatedQuotaDTO);
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalArgumentException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
            }
        });
    }

    public void defineGetQuota() {
        this.service.get(QUOTA_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            return this.userQuotaService.getQuota(username);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineGetUsersQuota() {
        this.service.get(USERS_QUOTA_ENDPOINT, (request, response) -> {
            QuotaQuery quotaQuery = QuotaQuery.builder().lessThan(this.extractQuotaBoundary(request, MAX_OCCUPATION_RATIO)).moreThan(this.extractQuotaBoundary(request, MIN_OCCUPATION_RATIO)).hasDomain(this.extractDomain(request, DOMAIN)).withLimit(this.extractLimit(request)).withOffset(this.extractOffset(request)).build();
            return this.userQuotaService.getUsersQuota(quotaQuery);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public Optional<Domain> extractDomain(Request request, String parameterName) {
        return Optional.ofNullable(request.queryParams(parameterName)).map(Domain::of);
    }

    public Optional<QuotaBoundary> extractQuotaBoundary(Request request, String parameterName) {
        return ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName).map(QuotaBoundary::new);
    }

    public Limit extractLimit(Request request) {
        return ParametersExtractor.extractLimit((Request)request).getLimit().map(Limit::of).orElse(Limit.unlimited());
    }

    public Offset extractOffset(Request request) {
        return Offset.of((int)ParametersExtractor.extractOffset((Request)request).getOffset());
    }

    public void defineDeleteQuotaSize() {
        this.service.delete(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            this.userQuotaService.deleteMaxSizeQuota(username);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineUpdateQuotaSize() {
        this.service.put(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            QuotaSizeLimit quotaSize = Quotas.quotaSize(request.body());
            this.userQuotaService.defineMaxSizeQuota(username, quotaSize);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineGetQuotaSize() {
        this.service.get(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            Optional<QuotaSizeLimit> maxSizeQuota = this.userQuotaService.getMaxSizeQuota(username);
            if (maxSizeQuota.isPresent()) {
                return maxSizeQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineDeleteQuotaCount() {
        this.service.delete(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            this.userQuotaService.deleteMaxCountQuota(username);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineUpdateQuotaCount() {
        this.service.put(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            QuotaCountLimit quotaCount = Quotas.quotaCount(request.body());
            this.userQuotaService.defineMaxCountQuota(username, quotaCount);
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineGetQuotaCount() {
        this.service.get(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            Optional<QuotaCountLimit> maxCountQuota = this.userQuotaService.getMaxCountQuota(username);
            if (maxCountQuota.isPresent()) {
                return maxCountQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    private Username checkUserExist(Request request) throws UsersRepositoryException {
        Username username = Username.of((String)request.params(USER));
        if (!this.usersRepository.contains(username)) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("User not found").haltError();
        }
        return username;
    }

    public static class RecomputeCurrentQuotasRequestToTask
    extends TaskFromRequestRegistry.TaskRegistration {
        private static final String USERS_PER_SECOND = "usersPerSecond";
        private static final String QUOTA_COMPONENT = "quotaComponent";
        private static final ImmutableMap<String, QuotaComponent> QUOTA_COMPONENT_MAP = ImmutableMap.of((Object)QuotaComponent.MAILBOX.getValue(), (Object)QuotaComponent.MAILBOX, (Object)QuotaComponent.SIEVE.getValue(), (Object)QuotaComponent.SIEVE, (Object)QuotaComponent.JMAP_UPLOADS.getValue(), (Object)QuotaComponent.JMAP_UPLOADS);

        @Inject
        public RecomputeCurrentQuotasRequestToTask(RecomputeCurrentQuotasService service) {
            super(RECOMPUTE_CURRENT_QUOTAS, request -> new RecomputeCurrentQuotasTask(service, RecomputeCurrentQuotasRequestToTask.parseRunningOptions(request)));
        }

        private static RecomputeCurrentQuotasService.RunningOptions parseRunningOptions(Request request) {
            return RecomputeCurrentQuotasService.RunningOptions.of((int)RecomputeCurrentQuotasRequestToTask.intQueryParameter(request).orElse(1), RecomputeCurrentQuotasRequestToTask.getQuotaComponent(request));
        }

        private static Optional<Integer> intQueryParameter(Request request) {
            try {
                return Optional.ofNullable(request.queryParams(USERS_PER_SECOND)).map(Integer::parseInt);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Illegal value supplied for query parameter '%s', expecting a strictly positive optional integer", USERS_PER_SECOND), e);
            }
        }

        private static List<QuotaComponent> getQuotaComponent(Request request) {
            return Optional.ofNullable(request.queryParamsValues(QUOTA_COMPONENT)).map(quotaComponentStrings -> Arrays.stream(quotaComponentStrings).map(quotaComponentString -> Optional.ofNullable((QuotaComponent)QUOTA_COMPONENT_MAP.get((Object)quotaComponentString.toUpperCase())).orElseThrow(() -> new IllegalArgumentException(String.format("Illegal value supplied for query parameter '%s' with value '%s', expecting existing quota components", QUOTA_COMPONENT, quotaComponentString)))).collect(Collectors.toUnmodifiableList())).orElse((List)ImmutableList.of());
        }
    }
}

