/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceLoader;
import org.apache.james.utils.MailetConfigurationOverride;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PackageName;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;

public class GuiceMailetLoader
implements MailetLoader {
    private static final PackageName STANDARD_PACKAGE = PackageName.of((String)"org.apache.james.transport.mailets.");
    private static final NamingScheme MAILET_NAMING_SCHEME = new NamingScheme.OptionalPackagePrefix(STANDARD_PACKAGE);
    private final GuiceLoader genericLoader;
    private final Map<Class<? extends Mailet>, MailetConfig> configurationOverrides;

    @Inject
    public GuiceMailetLoader(GuiceLoader genericLoader, Set<MailetConfigurationOverride> mailetConfigurationOverrides) {
        this.genericLoader = genericLoader;
        this.configurationOverrides = (Map)mailetConfigurationOverrides.stream().collect(ImmutableMap.toImmutableMap(MailetConfigurationOverride::getClazz, MailetConfigurationOverride::getNewConfiguration));
    }

    public Mailet getMailet(MailetConfig config) throws MessagingException {
        try {
            ClassName className = new ClassName(config.getMailetName());
            GuiceLoader.InvocationPerformer mailetLoader = this.genericLoader.withNamingSheme(MAILET_NAMING_SCHEME);
            Class mailetClass = mailetLoader.locateClass(className);
            MailetConfig mailetConfig = this.resolveConfiguration(mailetClass, config);
            Mailet result = (Mailet)mailetLoader.withChildModule(binder -> binder.bind(MailetConfig.class).toInstance((Object)mailetConfig)).instantiate(className);
            result.init(this.resolveConfiguration(result, config));
            return result;
        }
        catch (Exception e) {
            throw new MessagingException("Can not load mailet " + config.getMailetName(), e);
        }
    }

    private MailetConfig resolveConfiguration(Mailet result, MailetConfig providedConfiguration) {
        return Optional.ofNullable(this.configurationOverrides.get(result.getClass())).orElse(providedConfiguration);
    }

    private MailetConfig resolveConfiguration(Class<?> mailetClass, MailetConfig providedConfiguration) {
        return Optional.ofNullable(this.configurationOverrides.get(mailetClass)).orElse(providedConfiguration);
    }
}

