/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.github.fge.lambdas.functions.ThrowingFunction;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.imap.ImapSuite;
import org.apache.james.imap.api.ConnectionCheckFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;

public class IMAPServerFactory
extends AbstractServerFactory
implements Disconnector,
ConnectionDescriptionSupplier {
    protected final FileSystem fileSystem;
    protected final ThrowingFunction<HierarchicalConfiguration<ImmutableNode>, ImapSuite> imapSuiteProvider;
    protected final ImapMetrics imapMetrics;
    protected final GaugeRegistry gaugeRegistry;
    protected final ConnectionCheckFactory connectionCheckFactory;

    @Inject
    @Deprecated
    public IMAPServerFactory(FileSystem fileSystem, ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, MetricFactory metricFactory, GaugeRegistry gaugeRegistry, ConnectionCheckFactory connectionCheckFactory) {
        this.fileSystem = fileSystem;
        this.connectionCheckFactory = connectionCheckFactory;
        this.imapSuiteProvider = any -> new ImapSuite(decoder, encoder, processor);
        this.imapMetrics = new ImapMetrics(metricFactory);
        this.gaugeRegistry = gaugeRegistry;
    }

    public IMAPServerFactory(FileSystem fileSystem, ThrowingFunction<HierarchicalConfiguration<ImmutableNode>, ImapSuite> imapSuiteProvider, MetricFactory metricFactory, GaugeRegistry gaugeRegistry, ConnectionCheckFactory connectionCheckFactory) {
        this.fileSystem = fileSystem;
        this.imapSuiteProvider = imapSuiteProvider;
        this.imapMetrics = new ImapMetrics(metricFactory);
        this.gaugeRegistry = gaugeRegistry;
        this.connectionCheckFactory = connectionCheckFactory;
    }

    protected IMAPServer createServer(HierarchicalConfiguration<ImmutableNode> config) {
        ImapSuite imapSuite = (ImapSuite)this.imapSuiteProvider.apply(config);
        return new IMAPServer(imapSuite.getDecoder(), imapSuite.getEncoder(), imapSuite.getProcessor(), this.imapMetrics, this.gaugeRegistry, this.connectionCheckFactory.create(config));
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("imapserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            IMAPServer server = this.createServer((HierarchicalConfiguration<ImmutableNode>)serverConfig);
            server.setFileSystem(this.fileSystem);
            server.configure(serverConfig);
            servers.add(server);
        }
        return servers;
    }

    public List<IMAPServer> getImapServers() {
        return this.getServers().stream().filter(AbstractConfigurableAsyncServer::isEnabled).map(IMAPServer.class::cast).toList();
    }

    public void disconnect(Predicate<Username> username) {
        this.getServers().stream().map(server -> (IMAPServer)server).forEach(imapServer -> imapServer.disconnect(username));
    }

    public Stream<ConnectionDescription> describeConnections() {
        return this.getServers().stream().map(server -> (IMAPServer)server).flatMap(IMAPServer::describeConnections);
    }
}

