/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.change;

import com.google.common.collect.ImmutableList;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.postgres.change.PostgresEmailChangeDataDefinition;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.jooq.OrderField;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresEmailChangeDAO {
    private final PostgresExecutor postgresExecutor;

    public PostgresEmailChangeDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> insert(EmailChange change) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.TABLE_NAME).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.ACCOUNT_ID, (Object)change.getAccountId().getIdentifier()).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE, (Object)change.getState().getValue()).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.IS_SHARED, (Object)change.isShared()).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.CREATED, (Object)this.convertToUUIDArray(change.getCreated())).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.UPDATED, (Object)this.convertToUUIDArray(change.getUpdated())).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.DESTROYED, (Object)this.convertToUUIDArray(change.getDestroyed())).set(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.DATE, (Object)change.getDate().toOffsetDateTime())));
    }

    public Flux<EmailChange> getAllChanges(AccountId accountId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.TABLE_NAME).where(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())))).map(record -> this.readRecord((Record)record, accountId));
    }

    public Flux<EmailChange> getChangesSince(AccountId accountId, State state) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.TABLE_NAME).where(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).and(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE.greaterOrEqual((Object)state.getValue())).orderBy(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE))).map(record -> this.readRecord((Record)record, accountId));
    }

    public Mono<State> latestState(AccountId accountId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE).from(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.TABLE_NAME).where(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).orderBy((OrderField)PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE.desc()).limit((Number)1))).map(record -> State.of((UUID)((UUID)record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE))));
    }

    public Mono<State> latestStateNotDelegated(AccountId accountId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE).from(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.TABLE_NAME).where(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).and(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.IS_SHARED.eq((Object)false)).orderBy((OrderField)PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE.desc()).limit((Number)1))).map(record -> State.of((UUID)((UUID)record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE))));
    }

    private UUID[] convertToUUIDArray(List<MessageId> messageIds) {
        return (UUID[])messageIds.stream().map(PostgresMessageId.class::cast).map(PostgresMessageId::asUuid).toArray(UUID[]::new);
    }

    private EmailChange readRecord(Record record, AccountId accountId) {
        return EmailChange.builder().accountId(accountId).state(State.of((UUID)((UUID)record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.STATE)))).date(((OffsetDateTime)record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.DATE)).toZonedDateTime()).isShared(((Boolean)record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.IS_SHARED)).booleanValue()).created(this.convertToMessageIdList((UUID[])record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.CREATED))).updated(this.convertToMessageIdList((UUID[])record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.UPDATED))).destroyed(this.convertToMessageIdList((UUID[])record.get(PostgresEmailChangeDataDefinition.PostgresEmailChangeTable.DESTROYED))).build();
    }

    private List<MessageId> convertToMessageIdList(UUID[] uuids) {
        return (List)Arrays.stream(uuids).map(PostgresMessageId.Factory::of).collect(ImmutableList.toImmutableList());
    }
}

