/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.services.TasksCleanupService;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TasksCleanupTask;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class TasksCleanupRoutes
implements Routes {
    public static final String BASE_PATH = "/tasks";
    private final TaskManager taskManager;
    private final Clock clock;
    private final TasksCleanupService tasksCleanupService;
    private final JsonTransformer jsonTransformer;

    @Inject
    public TasksCleanupRoutes(TaskManager taskManager, Clock clock, TasksCleanupService tasksCleanupService, JsonTransformer jsonTransformer) {
        this.taskManager = taskManager;
        this.clock = clock;
        this.tasksCleanupService = tasksCleanupService;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        TaskFromRequest tasksCleanupFromRequest = this::tasksCleanupTask;
        service.delete(BASE_PATH, tasksCleanupFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task tasksCleanupTask(Request request) {
        Duration olderThanDuration = (Duration)ParametersExtractor.extractDuration((Request)request, (String)"olderThan").orElseThrow(() -> new IllegalArgumentException("missing or invalid `olderThan` parameter"));
        Instant olderThan = this.clock.instant().minusSeconds(olderThanDuration.toSeconds());
        return new TasksCleanupTask(this.tasksCleanupService, olderThan);
    }
}

