/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.PropertyManager;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FormattableColumn
implements Serializable {
    @NotNull
    public static final String CSV_QUOTE_ESCAPE_CHARACTER_PROPERTY = FormattableColumn.class.getName() + ".csvQuoteEscapeCharacter";
    private static volatile char CSV_QUOTE_ESCAPE_CHARACTER;
    private static final long serialVersionUID = -67186391702592665L;
    @NotNull
    private final HorizontalAlignment alignment;
    private final int width;
    @NotNull
    private final String[] labelLines;

    public FormattableColumn(int width, @NotNull HorizontalAlignment alignment, String ... labelLines) {
        Validator.ensureTrue(width >= 1);
        Validator.ensureNotNull((Object)alignment, labelLines);
        this.width = width;
        this.alignment = alignment;
        this.labelLines = labelLines;
    }

    public int getWidth() {
        return this.width;
    }

    @NotNull
    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public String[] getLabelLines() {
        return this.labelLines;
    }

    @NotNull
    public String getSingleLabelLine() {
        switch (this.labelLines.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this.labelLines[0];
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.labelLines[0]);
        for (int i = 1; i < this.labelLines.length; ++i) {
            buffer.append(' ');
            buffer.append(this.labelLines[i]);
        }
        return buffer.toString();
    }

    public void format(@NotNull StringBuilder buffer, @NotNull String text, @NotNull OutputFormat format) {
        switch (format) {
            case TAB_DELIMITED_TEXT: {
                block11: for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '\t': {
                            buffer.append("\\t");
                            continue block11;
                        }
                        case '\r': {
                            buffer.append("\\r");
                            continue block11;
                        }
                        case '\n': {
                            buffer.append("\\n");
                            continue block11;
                        }
                        case '\\': {
                            buffer.append("\\\\");
                            continue block11;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                }
                break;
            }
            case CSV: {
                boolean quotesNeeded = false;
                int length = text.length();
                int startPos = buffer.length();
                for (int i = 0; i < length; ++i) {
                    char c = text.charAt(i);
                    if (c == ',') {
                        buffer.append(',');
                        quotesNeeded = true;
                        continue;
                    }
                    if (c == '\"') {
                        buffer.append(CSV_QUOTE_ESCAPE_CHARACTER);
                        buffer.append(c);
                        quotesNeeded = true;
                        continue;
                    }
                    if (c == CSV_QUOTE_ESCAPE_CHARACTER) {
                        buffer.append(c);
                        buffer.append(c);
                        quotesNeeded = true;
                        continue;
                    }
                    if (c == '\\') {
                        buffer.append(c);
                        quotesNeeded = true;
                        continue;
                    }
                    if (c >= ' ' && c <= '~') {
                        buffer.append(c);
                        continue;
                    }
                    buffer.append(c);
                    quotesNeeded = true;
                }
                if (!quotesNeeded) break;
                buffer.insert(startPos, '\"');
                buffer.append('\"');
                break;
            }
            case COLUMNS: {
                this.alignment.format(buffer, text, this.width);
            }
        }
    }

    public static void setCSVQuoteEscapeCharacter(char c) {
        CSV_QUOTE_ESCAPE_CHARACTER = c;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("FormattableColumn(width=");
        buffer.append(this.width);
        buffer.append(", alignment=");
        buffer.append((Object)this.alignment);
        buffer.append(", label=\"");
        buffer.append(this.getSingleLabelLine());
        buffer.append("\")");
    }

    static {
        int escapeCharacter = 34;
        String propertyValue = PropertyManager.get(CSV_QUOTE_ESCAPE_CHARACTER_PROPERTY);
        if (propertyValue != null && propertyValue.length() == 1) {
            escapeCharacter = propertyValue.charAt(0);
        }
        CSV_QUOTE_ESCAPE_CHARACTER = (char)escapeCharacter;
    }
}

