/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class ListenerExecutor {
    private static final Duration TIMEOUT = Duration.ofMinutes(10L);
    private final MetricFactory metricFactory;

    ListenerExecutor(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    Mono<Void> execute(EventListener.ReactiveEventListener listener, MDCBuilder mdcBuilder, Event event) {
        if (listener.isHandling(event)) {
            return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(EventBus.Metrics.timerName((EventListener)listener), (Publisher)Mono.from((Publisher)listener.reactiveEvent(event)).contextWrite((ContextView)ReactorUtils.context((String)"ListenerExecutor", (MDCBuilder)this.mdc((EventListener)listener, mdcBuilder, event))).timeout(TIMEOUT)));
        }
        return Mono.empty();
    }

    Mono<Void> execute(EventListener.ReactiveEventListener listener, MDCBuilder mdcBuilder, List<Event> events) {
        if (events.size() == 1) {
            return this.execute(listener, mdcBuilder, events.getFirst());
        }
        if (events.stream().noneMatch(arg_0 -> ((EventListener.ReactiveEventListener)listener).isHandling(arg_0))) {
            return Mono.empty();
        }
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(EventBus.Metrics.timerName((EventListener)listener), (Publisher)Mono.from((Publisher)listener.reactiveEvent(events)).contextWrite((ContextView)ReactorUtils.context((String)"ListenerExecutor", (MDCBuilder)this.mdc((EventListener)listener, mdcBuilder, events))).timeout(TIMEOUT)));
    }

    private MDCBuilder mdc(EventListener listener, MDCBuilder mdcBuilder, Event event) {
        return mdcBuilder.addToContext("eventId", event.getEventId().getId().toString()).addToContext("eventClass", event.getClass().getCanonicalName()).addToContext("user", event.getUsername().asString()).addToContext("listenerClass", listener.getClass().getCanonicalName());
    }

    private MDCBuilder mdc(EventListener listener, MDCBuilder mdcBuilder, List<Event> events) {
        if (events.size() == 1) {
            return mdcBuilder.addToContext("eventId", events.getFirst().getEventId().toString()).addToContext("eventClass", events.getFirst().getClass().getCanonicalName()).addToContext("user", events.getFirst().getUsername().asString()).addToContext("listenerClass", listener.getClass().getCanonicalName());
        }
        return mdcBuilder.addToContext("eventId", events.stream().map(e -> e.getEventId().getId().toString()).collect(Collectors.joining(","))).addToContext("eventClass", events.stream().map(e -> e.getClass().getCanonicalName()).collect(Collectors.joining(","))).addToContext("user", events.stream().map(e -> e.getUsername().asString()).collect(Collectors.joining(","))).addToContext("listenerClass", listener.getClass().getCanonicalName());
    }
}

