/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SortableBytesRefArray;
import org.apache.lucene.util.StableStringSorter;
import org.apache.lucene.util.StringSorter;

public final class BytesRefArray
implements SortableBytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 4L);
        this.bytesUsed = bytesUsed;
    }

    @Override
    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    @Override
    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((long)(this.offsets.length - oldLen) * 4L);
        }
        this.pool.append(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement - 1;
    }

    @Override
    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRefBuilder spare, int index) {
        Objects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        spare.growNoCopy(length);
        spare.setLength(length);
        this.pool.readBytes(offset, spare.bytes(), 0, spare.length());
        return spare.get();
    }

    private void setBytesRef(BytesRefBuilder spare, BytesRef result, int index) {
        Objects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        this.pool.setBytesRef(spare, result, offset, length);
    }

    public SortState sort(Comparator<BytesRef> comp, boolean stable) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        StringSorter sorter = stable ? new StableStringSorter(comp){
            private final int[] tmp;
            {
                super(cmp);
                this.tmp = new int[BytesRefArray.this.size()];
            }

            @Override
            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                BytesRefArray.this.setBytesRef(builder, result, orderedEntries[i]);
            }

            @Override
            protected void save(int i, int j) {
                this.tmp[j] = orderedEntries[i];
            }

            @Override
            protected void restore(int i, int j) {
                System.arraycopy(this.tmp, i, orderedEntries, i, j - i);
            }

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }
        } : new StringSorter(comp){

            @Override
            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                BytesRefArray.this.setBytesRef(builder, result, orderedEntries[i]);
            }

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }
        };
        sorter.sort(0, this.size());
        return new SortState(orderedEntries);
    }

    public BytesRefIterator iterator() {
        return this.iterator((SortState)null);
    }

    @Override
    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        return this.iterator(this.sort(comp, false));
    }

    public IndexedBytesRefIterator iterator(SortState sortState) {
        int[] indices;
        final int size = this.size();
        int[] nArray = indices = sortState == null ? null : sortState.indices;
        assert (indices == null || indices.length == size) : indices.length + " != " + size;
        final BytesRefBuilder spare = new BytesRefBuilder();
        final BytesRef result = new BytesRef();
        return new IndexedBytesRefIterator(){
            int pos = -1;
            int ord = 0;

            @Override
            public BytesRef next() {
                ++this.pos;
                if (this.pos < size) {
                    this.ord = indices == null ? this.pos : indices[this.pos];
                    BytesRefArray.this.setBytesRef(spare, result, this.ord);
                    return result;
                }
                return null;
            }

            @Override
            public int ord() {
                return this.ord;
            }
        };
    }

    public static final class SortState
    implements Accountable {
        private final int[] indices;

        private SortState(int[] indices) {
            this.indices = indices;
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.indices.length * 4;
        }
    }

    public static interface IndexedBytesRefIterator
    extends BytesRefIterator {
        public int ord();
    }
}

