/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.api;

import org.apache.james.jdkim.api.SignatureRecord;

public class Result {
    private final String errorMessage;
    private final String dkimRawField;
    private final SignatureRecord record;
    private final Type type;

    public Result(String errorMessage, String dkimRawField, SignatureRecord record, Type type) {
        this.errorMessage = errorMessage;
        this.dkimRawField = dkimRawField;
        this.record = record;
        this.type = type;
    }

    public Result(SignatureRecord record) {
        this.errorMessage = null;
        this.dkimRawField = null;
        this.record = record;
        this.type = Type.PASS;
    }

    public String getHeaderTextWithReason() {
        return this.getHeaderText(true);
    }

    public String getHeaderText() {
        return this.getHeaderText(false);
    }

    private String getHeaderText(boolean withReason) {
        if (this.record == null) {
            return "";
        }
        String partialSig = "";
        String reasonProp = "";
        if (this.record.getRawSignature() != null) {
            partialSig = this.record.getRawSignature().length() >= 12 ? " header.b=" + this.record.getRawSignature().subSequence(0, 12) : " header.b=" + this.record.getRawSignature();
        }
        if (withReason) {
            String reasonMsg;
            switch (this.type.ordinal()) {
                case 1: {
                    reasonMsg = "valid signature";
                    break;
                }
                case 0: {
                    reasonMsg = "unknown error";
                    break;
                }
                default: {
                    reasonMsg = this.errorMessage != null ? this.errorMessage : "";
                }
            }
            reasonProp = reasonMsg.isEmpty() ? "" : String.format(" reason=\"%s\"", reasonMsg);
        }
        return String.format("dkim=%s header.d=%s header.s=%s%s%s", this.type.toString().toLowerCase(), this.record.getDToken(), this.record.getSelector(), partialSig, reasonProp);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getDkimRawField() {
        return this.dkimRawField;
    }

    public boolean isSuccess() {
        return this.type == Type.PASS;
    }

    public boolean isFail() {
        return !this.isSuccess();
    }

    public SignatureRecord getRecord() {
        return this.record;
    }

    public Type getResultType() {
        return this.type;
    }

    public String toString() {
        return "Result{headerText='" + this.getHeaderText() + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", dkimRawField='" + this.dkimRawField + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        NONE,
        PASS,
        FAIL,
        POLICY,
        NEUTRAL,
        TEMPERROR,
        PERMERROR;

    }
}

