/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.stream.JsonParser;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opensearch.client.json.BuildFunctionDeserializer;
import org.opensearch.client.json.DelegatingDeserializer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.LazyDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ObjectBuilder;

public class ObjectBuilderDeserializer<T, B extends ObjectBuilder<T>>
extends DelegatingDeserializer<T, B> {
    private final JsonpDeserializer<B> builderDeserializer;

    public static <B extends ObjectBuilder<T>, T> JsonpDeserializer<T> lazy(Supplier<B> builderCtor, Consumer<ObjectDeserializer<B>> builderDeserializerSetup) {
        return new LazyDeserializer(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderDeserializerSetup.accept(builderDeser);
            return new ObjectBuilderDeserializer(builderDeser);
        });
    }

    public static <B, T> JsonpDeserializer<T> lazy(Supplier<B> builderCtor, Consumer<ObjectDeserializer<B>> builderDeserializerSetup, Function<B, T> buildFn) {
        return new LazyDeserializer(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderDeserializerSetup.accept(builderDeser);
            return new BuildFunctionDeserializer(builderDeser, buildFn);
        });
    }

    public static <T, B extends ObjectBuilder<T>> JsonpDeserializer<T> createForObject(Supplier<B> ctor, Consumer<ObjectDeserializer<B>> configurer) {
        ObjectDeserializer<B> op = new ObjectDeserializer<B>(ctor);
        configurer.accept(op);
        return new ObjectBuilderDeserializer<T, B>(op);
    }

    public ObjectBuilderDeserializer(JsonpDeserializer<B> builderDeserializer) {
        this.builderDeserializer = builderDeserializer;
    }

    @Override
    protected JsonpDeserializer<B> unwrap() {
        return this.builderDeserializer;
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper) {
        ObjectBuilder builder = (ObjectBuilder)this.builderDeserializer.deserialize(parser, mapper);
        return builder.build();
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        ObjectBuilder builder = (ObjectBuilder)this.builderDeserializer.deserialize(parser, mapper, event);
        return builder.build();
    }
}

