/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Tokenizer
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Tokenizer> _DESERIALIZER = JsonpDeserializer.lazy(Tokenizer::buildTokenizerDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Tokenizer(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Tokenizer(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Tokenizer of(Function<Builder, ObjectBuilder<Tokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDefinition() {
        return this._kind == Kind.Definition;
    }

    public TokenizerDefinition definition() {
        return (TokenizerDefinition)TaggedUnionUtils.get(this, Kind.Definition);
    }

    public boolean isName() {
        return this._kind == Kind.Name;
    }

    public String name() {
        return (String)TaggedUnionUtils.get(this, Kind.Name);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Name: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<Tokenizer> buildTokenizerDeserializer() {
        return new UnionDeserializer.Builder<Tokenizer, Kind, Object>(Tokenizer::new, false).addMember(Kind.Definition, TokenizerDefinition._DESERIALIZER).addMember(Kind.Name, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Tokenizer> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Tokenizer> definition(TokenizerDefinition v) {
            this._kind = Kind.Definition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Tokenizer> definition(Function<TokenizerDefinition.Builder, ObjectBuilder<TokenizerDefinition>> fn) {
            return this.definition(fn.apply(new TokenizerDefinition.Builder()).build());
        }

        public ObjectBuilder<Tokenizer> name(String v) {
            this._kind = Kind.Name;
            this._value = v;
            return this;
        }

        @Override
        public Tokenizer build() {
            this._checkSingleUse();
            return new Tokenizer(this);
        }
    }

    public static enum Kind {
        Definition,
        Name;

    }
}

