/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Context
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Context> _DESERIALIZER = JsonpDeserializer.lazy(Context::buildContextDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Context(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Context(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Context of(Function<Builder, ObjectBuilder<Context>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isLocation() {
        return this._kind == Kind.Location;
    }

    public GeoLocation location() {
        return (GeoLocation)TaggedUnionUtils.get(this, Kind.Location);
    }

    public boolean isCategory() {
        return this._kind == Kind.Category;
    }

    public String category() {
        return (String)TaggedUnionUtils.get(this, Kind.Category);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Category: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<Context> buildContextDeserializer() {
        return new UnionDeserializer.Builder<Context, Kind, Object>(Context::new, true).addMember(Kind.Location, GeoLocation._DESERIALIZER).addMember(Kind.Category, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Context> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Context> location(GeoLocation v) {
            this._kind = Kind.Location;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Context> location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        public ObjectBuilder<Context> category(String v) {
            this._kind = Kind.Category;
            this._value = v;
            return this;
        }

        @Override
        public Context build() {
            this._checkSingleUse();
            return new Context(this);
        }
    }

    public static enum Kind {
        Location,
        Category;

    }
}

