/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.resources.LoopResources;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class QuicResources
implements LoopResources {
    final LoopResources defaultLoops;
    static final Logger log = Loggers.getLogger(QuicResources.class);
    static final Function<LoopResources, QuicResources> ON_QUIC_NEW = QuicResources::new;
    static final AtomicReference<QuicResources> quicResources = new AtomicReference();

    public static QuicResources get() {
        return QuicResources.getOrCreate(null, ON_QUIC_NEW, "quic");
    }

    public static QuicResources reset() {
        QuicResources.disposeLoops();
        return QuicResources.getOrCreate(null, ON_QUIC_NEW, "quic");
    }

    public static QuicResources set(LoopResources loops) {
        return QuicResources.getOrCreate(loops, ON_QUIC_NEW, "quic");
    }

    public static void disposeLoops() {
        QuicResources resources = quicResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsLater() {
        return QuicResources.disposeLoopsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            QuicResources resources = quicResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    protected QuicResources(LoopResources defaultLoops) {
        this.defaultLoops = defaultLoops;
    }

    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    public void dispose() {
    }

    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.empty();
    }

    public boolean isDisposed() {
        return this.defaultLoops.isDisposed();
    }

    public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return (CHANNEL)this.defaultLoops.onChannel(channelType, group);
    }

    public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannelClass(channelType, group);
    }

    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    protected void _dispose() {
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout) {
        return this.defaultLoops.disposeLater(quietPeriod, timeout);
    }

    protected static QuicResources getOrCreate(@Nullable LoopResources loops, Function<LoopResources, QuicResources> onNew, String name) {
        QuicResources resources;
        while ((resources = quicResources.get()) == null || loops != null) {
            QuicResources update = QuicResources.create(resources, loops, name, onNew);
            if (quicResources.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (log.isWarnEnabled()) {
                        log.warn("[{}] resources will use a new LoopResources: {},the previous LoopResources will be disposed", new Object[]{name, loops});
                    }
                    resources.defaultLoops.dispose();
                } else {
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", new Object[]{name, loopType, update.defaultLoops});
                    }
                }
                return update;
            }
            update._dispose();
        }
        return resources;
    }

    static <T extends QuicResources> T create(@Nullable T previous, @Nullable LoopResources loops, String name, Function<LoopResources, T> onNew) {
        loops = previous == null ? (loops == null ? LoopResources.create((String)name, (int)Runtime.getRuntime().availableProcessors(), (boolean)true) : loops) : (loops == null ? previous.defaultLoops : loops);
        return (T)((QuicResources)onNew.apply(loops));
    }
}

