/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.cassandra.projections.table.CassandraEmailQueryViewTable;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEmailQueryView
implements EmailQueryView {
    private static final String LIMIT_MARKER = "LIMIT_BIND_MARKER";
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement listMailboxContentBySentAt;
    private final PreparedStatement listMailboxContentByReceivedAt;
    private final PreparedStatement listMailboxContentSinceSentAt;
    private final PreparedStatement listMailboxContentSinceReceivedAt;
    private final PreparedStatement listMailboxContentBeforeReceivedAt;
    private final PreparedStatement insertInLookupTable;
    private final PreparedStatement insertReceivedAt;
    private final PreparedStatement insertSentAt;
    private final PreparedStatement deleteLookupRecord;
    private final PreparedStatement deleteSentAt;
    private final PreparedStatement deleteReceivedAt;
    private final PreparedStatement deleteAllLookupRecords;
    private final PreparedStatement deleteAllSentAt;
    private final PreparedStatement deleteAllReceivedAt;
    private final PreparedStatement lookupDate;

    @Inject
    public CassandraEmailQueryView(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.listMailboxContentBySentAt = session.prepare(((Select)QueryBuilder.selectFrom((String)"email_query_view_sent_at").column(CassandraEmailQueryViewTable.MESSAGE_ID).whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).orderBy(CassandraEmailQueryViewTable.SENT_AT, ClusteringOrder.DESC).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)).build());
        this.listMailboxContentByReceivedAt = session.prepare(((Select)QueryBuilder.selectFrom((String)"email_query_view_received_at").column(CassandraEmailQueryViewTable.MESSAGE_ID).whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).orderBy(CassandraEmailQueryViewTable.RECEIVED_AT, ClusteringOrder.DESC).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)).build());
        this.listMailboxContentSinceSentAt = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_query_view_sent_at").column(CassandraEmailQueryViewTable.MESSAGE_ID).whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.SENT_AT).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.SENT_AT))).orderBy(CassandraEmailQueryViewTable.SENT_AT, ClusteringOrder.DESC).limit(QueryBuilder.bindMarker((String)LIMIT_MARKER)).build());
        this.listMailboxContentSinceReceivedAt = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_query_view_received_at").columns(new CqlIdentifier[]{CassandraEmailQueryViewTable.MESSAGE_ID, CassandraEmailQueryViewTable.SENT_AT}).whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.RECEIVED_AT).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.RECEIVED_AT))).orderBy(CassandraEmailQueryViewTable.RECEIVED_AT, ClusteringOrder.DESC).build());
        this.listMailboxContentBeforeReceivedAt = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_query_view_received_at").columns(new CqlIdentifier[]{CassandraEmailQueryViewTable.MESSAGE_ID, CassandraEmailQueryViewTable.SENT_AT}).whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.RECEIVED_AT).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.RECEIVED_AT))).orderBy(CassandraEmailQueryViewTable.RECEIVED_AT, ClusteringOrder.DESC).build());
        this.insertInLookupTable = session.prepare(QueryBuilder.insertInto((String)"email_query_view_date_lookup").value(CassandraEmailQueryViewTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID)).value(CassandraEmailQueryViewTable.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID)).value(CassandraEmailQueryViewTable.SENT_AT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.SENT_AT)).value(CassandraEmailQueryViewTable.RECEIVED_AT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.RECEIVED_AT)).build());
        this.insertSentAt = session.prepare(QueryBuilder.insertInto((String)"email_query_view_sent_at").value(CassandraEmailQueryViewTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID)).value(CassandraEmailQueryViewTable.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID)).value(CassandraEmailQueryViewTable.SENT_AT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.SENT_AT)).build());
        this.insertReceivedAt = session.prepare(QueryBuilder.insertInto((String)"email_query_view_received_at").value(CassandraEmailQueryViewTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID)).value(CassandraEmailQueryViewTable.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID)).value(CassandraEmailQueryViewTable.RECEIVED_AT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.RECEIVED_AT)).value(CassandraEmailQueryViewTable.SENT_AT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.SENT_AT)).build());
        this.deleteLookupRecord = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"email_query_view_date_lookup").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID))).build());
        this.deleteSentAt = session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"email_query_view_sent_at").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID))).whereColumn(CassandraEmailQueryViewTable.SENT_AT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.SENT_AT))).build());
        this.deleteReceivedAt = session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"email_query_view_received_at").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID))).whereColumn(CassandraEmailQueryViewTable.RECEIVED_AT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.RECEIVED_AT))).build());
        this.deleteAllLookupRecords = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"email_query_view_date_lookup").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).build());
        this.deleteAllSentAt = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"email_query_view_sent_at").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).build());
        this.deleteAllReceivedAt = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"email_query_view_received_at").whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).build());
        this.lookupDate = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_query_view_date_lookup").all().whereColumn(CassandraEmailQueryViewTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MAILBOX_ID))).whereColumn(CassandraEmailQueryViewTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailQueryViewTable.MESSAGE_ID))).build());
    }

    public Flux<MessageId> listMailboxContentSortedBySentAt(MailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)this.listMailboxContentBySentAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue())).map(row -> CassandraMessageId.Factory.of((UUID)((UUID)row.get(0, TypeCodecs.UUID))));
    }

    public Flux<MessageId> listMailboxContentSortedByReceivedAt(MailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)this.listMailboxContentByReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue())).map(row -> CassandraMessageId.Factory.of((UUID)((UUID)row.get(0, TypeCodecs.UUID))));
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedBySentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)this.listMailboxContentSinceReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, since.toInstant())).map(row -> {
            CassandraMessageId messageId = CassandraMessageId.Factory.of((UUID)row.getUuid(CassandraEmailQueryViewTable.MESSAGE_ID));
            Instant sentAt = row.getInstant(CassandraEmailQueryViewTable.SENT_AT);
            return Pair.of((Object)messageId, (Object)sentAt);
        }).sort(Comparator.comparing(Pair::getValue).reversed()).map(pair -> (MessageId)pair.getKey()).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedByReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)this.listMailboxContentSinceReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, since.toInstant())).map(row -> CassandraMessageId.Factory.of((UUID)((UUID)row.get(0, TypeCodecs.UUID)))).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    public Flux<MessageId> listMailboxContentBeforeSortedByReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)this.listMailboxContentBeforeReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, since.toInstant())).map(row -> CassandraMessageId.Factory.of((UUID)((UUID)row.get(0, TypeCodecs.UUID)))).take((long)((Integer)limit.getLimit().get()).intValue());
    }

    public Flux<MessageId> listMailboxContentSinceSentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)((BoundStatement)((BoundStatement)this.listMailboxContentSinceSentAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInt(LIMIT_MARKER, ((Integer)limit.getLimit().get()).intValue())).setInstant(CassandraEmailQueryViewTable.SENT_AT, since.toInstant())).map(row -> CassandraMessageId.Factory.of((UUID)((UUID)row.get(0, TypeCodecs.UUID))));
    }

    public Mono<Void> delete(MailboxId mailboxId, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeSingleRow((Statement)((BoundStatement)this.lookupDate.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).flatMap(row -> this.doDelete(cassandraMessageId, cassandraId, (Row)row));
    }

    public Mono<? extends Void> doDelete(CassandraMessageId cassandraMessageId, CassandraId cassandraId, Row row) {
        Instant receivedAt = row.getInstant(CassandraEmailQueryViewTable.RECEIVED_AT);
        Instant sentAt = row.getInstant(CassandraEmailQueryViewTable.SENT_AT);
        return Flux.concat((Publisher[])new Publisher[]{this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteSentAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).setInstant(CassandraEmailQueryViewTable.SENT_AT, sentAt)), this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, receivedAt))}).then(this.executor.executeVoid((Statement)((BoundStatement)this.deleteLookupRecord.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())));
    }

    public Mono<Void> delete(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return Flux.concat((Publisher[])new Publisher[]{this.executor.executeVoid((Statement)this.deleteAllSentAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)), this.executor.executeVoid((Statement)this.deleteAllReceivedAt.bind(new Object[0]).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID))}).then(this.executor.executeVoid((Statement)this.deleteAllLookupRecords.bind(new Object[0]).setUuid(CassandraEmailQueryViewTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())));
    }

    public Mono<Void> save(MailboxId mailboxId, ZonedDateTime sentAt, ZonedDateTime receivedAt, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertInLookupTable.bind(new Object[0]).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, receivedAt.toInstant())).setInstant(CassandraEmailQueryViewTable.SENT_AT, sentAt.toInstant())).then(Flux.concat((Publisher[])new Publisher[]{this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertSentAt.bind(new Object[0]).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.SENT_AT, sentAt.toInstant())), this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertReceivedAt.bind(new Object[0]).setUuid(CassandraEmailQueryViewTable.MESSAGE_ID, cassandraMessageId.get())).set(CassandraEmailQueryViewTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.UUID)).setInstant(CassandraEmailQueryViewTable.RECEIVED_AT, receivedAt.toInstant())).setInstant(CassandraEmailQueryViewTable.SENT_AT, sentAt.toInstant()))}).then());
    }
}

