/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.tls;

import jakarta.mail.MessagingException;
import java.util.Arrays;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpRequireTlsMessageHook
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpRequireTlsMessageHook.class);
    public static final String REQUIRETLS = "REQUIRETLS";
    public static final String TLS_REQUIRED = "TLS-Required";
    public static final ProtocolSession.AttachmentKey<Boolean> REQUIRETLS_KEY = ProtocolSession.AttachmentKey.of((String)"REQUIRETLS", Boolean.class);

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        try {
            session.getAttachment(REQUIRETLS_KEY, ProtocolSession.State.Transaction).ifPresent(requireTsl -> mail.setAttribute(new Attribute(AttributeName.of((String)REQUIRETLS), AttributeValue.of((Boolean)true))));
            if (SmtpRequireTlsMessageHook.isTlsNotRequired(mail) && !SmtpRequireTlsMessageHook.isRequireTlsAttributeContains(mail)) {
                mail.setAttribute(new Attribute(AttributeName.of((String)REQUIRETLS), AttributeValue.of((Boolean)false)));
            }
        }
        catch (MessagingException e) {
            LOGGER.debug("Incorrect syntax when handling TLS-Required header field", (Throwable)e);
            return HookResult.builder().smtpReturnCode("501").hookReturnCode(HookReturnCode.deny()).smtpDescription("Incorrect syntax when handling TLS-Required header field").build();
        }
        return HookResult.DECLINED;
    }

    private static boolean isRequireTlsAttributeContains(Mail mail) {
        return mail.attributeNames().map(AttributeName::asString).anyMatch(attributeName -> attributeName.equals(REQUIRETLS));
    }

    private static boolean isTlsNotRequired(Mail mail) throws MessagingException {
        String[] headers = mail.getMessage().getHeader(TLS_REQUIRED);
        return headers != null && headers.length == 1 && Arrays.asList(headers).contains("No");
    }
}

