/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BooleanMatchingRule
extends MatchingRule {
    @NotNull
    private static final BooleanMatchingRule INSTANCE = new BooleanMatchingRule();
    @NotNull
    private static final ASN1OctetString TRUE_VALUE = new ASN1OctetString("TRUE");
    @NotNull
    private static final ASN1OctetString FALSE_VALUE = new ASN1OctetString("FALSE");
    @NotNull
    public static final String EQUALITY_RULE_NAME = "booleanMatch";
    @NotNull
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("booleanMatch");
    @NotNull
    public static final String EQUALITY_RULE_OID = "2.5.13.13";
    private static final long serialVersionUID = 5137725892611277972L;

    @NotNull
    public static BooleanMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleOID() {
        return null;
    }

    @Override
    public boolean valuesMatch(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        return this.normalize(value1).equals(this.normalize(value2));
    }

    @Override
    public boolean matchesSubstring(@NotNull ASN1OctetString value, @Nullable ASN1OctetString subInitial, @Nullable ASN1OctetString[] subAny, @Nullable ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        byte[] valueBytes = value.getValue();
        if (!(valueBytes.length != 4 || valueBytes[0] != 84 && valueBytes[0] != 116 || valueBytes[1] != 82 && valueBytes[1] != 114 || valueBytes[2] != 85 && valueBytes[2] != 117 || valueBytes[3] != 69 && valueBytes[3] != 101)) {
            return TRUE_VALUE;
        }
        if (!(valueBytes.length != 5 || valueBytes[0] != 70 && valueBytes[0] != 102 || valueBytes[1] != 65 && valueBytes[1] != 97 || valueBytes[2] != 76 && valueBytes[2] != 108 || valueBytes[3] != 83 && valueBytes[3] != 115 || valueBytes[4] != 69 && valueBytes[4] != 101)) {
            return FALSE_VALUE;
        }
        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_BOOLEAN_INVALID_VALUE.get());
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_BOOLEAN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

