/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.io.File;
import java.util.Map;
import org.apache.juneau.doc.internal.Console;
import org.apache.juneau.doc.internal.DocStore;

public class DocTag
implements Taglet {
    private static final String NAME = "doc";
    private static final DocStore STORE = new DocStore(new File("resources/docs.txt"));

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map tagletMap) {
        DocTag tag = new DocTag();
        tagletMap.put(tag.getName(), tag);
    }

    public String toString(Tag tag) {
        File f = tag.position().file();
        String key = tag.text();
        String href = null;
        String label = null;
        int i = key.indexOf(32);
        if (key.indexOf(32) != -1) {
            label = key.substring(i + 1);
            key = key.substring(0, i).trim();
        }
        String hrefRemainder = "";
        if (key.matches("^\\w+\\:\\/\\/.*")) {
            href = key;
            if (label == null) {
                label = href;
            }
        } else if (key.startsWith("org.apache.juneau")) {
            i = this.firstDelimiter(key, 0);
            href = i == -1 ? String.valueOf(key.replace('.', '/')) + "/package-summary.html" : String.valueOf(key.substring(0, i).replace('.', '/')) + "/package-summary.html" + key.substring(i);
            if (label == null) {
                label = href;
            }
        } else {
            DocStore.Link l;
            i = this.firstDelimiter(key, 0);
            if (i != -1) {
                hrefRemainder = key.substring(i);
                key = key.substring(0, i);
            }
            if ((l = STORE.getLink(key)) == null) {
                Console.error(tag.position(), "Unknown doc tag: {0}", key);
                return tag.text();
            }
            href = l.href;
            if (label == null) {
                label = l.label;
            }
        }
        if (label == null) {
            label = "link";
        }
        label = label.replace("<", "&lt;").replace(">", "&gt;");
        if (href.startsWith("#") && !f.getName().equals("overview.html")) {
            StringBuilder sb = new StringBuilder();
            while (true) {
                if ((f = f.getParentFile()) == null) {
                    Console.error(tag.position(), "Unknown doc tag href: {0}", tag.text());
                    return tag.text();
                }
                if (f.getName().equals("java")) break;
                sb.append("../");
            }
            sb.append("overview-summary.html" + href);
            href = sb.toString();
        }
        return "<a class='doclink' href='" + href + hrefRemainder + "'>" + label + "</a>";
    }

    public String toString(Tag[] tags) {
        return null;
    }

    private int firstDelimiter(String path, int from) {
        int i = path.indexOf(47, from);
        if (i == -1) {
            i = path.indexOf(35, from);
        }
        return i;
    }
}

