/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.async.impl;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.server.async.impl.AsyncCmisServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisRequestRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CmisRequestRunner.class);
    private final AsyncContext asyncContext;
    private final AsyncCmisServlet asyncServlet;

    public CmisRequestRunner(AsyncContext asyncContext, AsyncCmisServlet asyncServlet) {
        this.asyncContext = asyncContext;
        this.asyncServlet = asyncServlet;
    }

    @Override
    public void run() {
        try {
            this.asyncServlet.executeSync((HttpServletRequest)this.asyncContext.getRequest(), (HttpServletResponse)this.asyncContext.getResponse());
        }
        catch (Exception e) {
            LOG.error("Async Excpetion: {}", (Object)e.toString(), (Object)e);
            try {
                this.asyncServlet.sendError(e, (HttpServletRequest)this.asyncContext.getRequest(), (HttpServletResponse)this.asyncContext.getResponse());
            }
            catch (IOException ioe) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to send error responds: {}", (Object)ioe.toString(), (Object)ioe);
                }
            }
        }
        finally {
            this.asyncContext.complete();
        }
    }
}

